<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

class ElementJBRelatedAutoYandex extends Element 
{
    protected $_relatedItems = null;

    public function hasValue($params = array())
    {
        if ((int)$this->get('value', 1)) {
            $items = $this->_getRelatedAutoYandex($params);
            return !empty($items);
        }

        return false;
    }

    public function edit()
    {
		
		if ($layout = $this->getLayout('edit.php')) {
			
			$width_default = $this->config->get('width_default');
			$width_default = !empty($width_default) ? $width_default : '100%';
			$height_default = $this->config->get('height_default');
			$height_default = !empty($height_default) ? $height_default : '300px';
			$zoom_default = $this->config->get('zoom_default');
			$zoom_default =  !empty($zoom_default) ? $zoom_default : '12';
			$coords_default = $this->config->get('coords_default');
			$coords_default = !empty($coords_default) ? $coords_default : '44.527754,48.708152';

            return self::renderLayout(
                $layout,
                array(
                    'width_default'   => $width_default,
					'height_default'   => $height_default,
					'zoom_default'   => $zoom_default,
					'coords_default'   => $coords_default
                )
            );
        }

        return null;
		
    }
	
	public function renderSubmission() {
        return $this->edit();
	}
	
	public function validateSubmission($value, $params) {

	}

    private function _getRelatedAutoYandex($params)
    {
        if ($this->_relatedItems === null) {

            $item  = $this->getItem();
            $model = JBModelRelated::model();

            $this->_relatedItems = $model->getRelated($item, $this->config, $params);

            return $this->_relatedItems;
        }

        return $this->_relatedItems;
		
    }

	public function js($str, $isInline = false) { 
	    if ( $isInline ) { 
            $str = htmlspecialchars($str); 
        } 
        return preg_replace('/\r?\n/m', '\\n', str_replace('/', '\/', addslashes($str))); 
    }

    public function render($params = array())
    {
		
		$doc = JFactory::getDocument();
		$doc->addScript("http://api-maps.yandex.ru/2.1/?lang=ru_RU&coordorder=longlat");
		
        // init vars
        $params = $this->app->data->create($params);

        $items = $this->_getRelatedAutoYandex($params);

        $renderer = $this->app->renderer->create('item')->addPath(array($this->app->path->path('component.site:'), $this->_item->getApplication()->getTemplate()->getPath()));
		
		$plugin = JPluginHelper::getPlugin('system', 'jbrelatedautoyandex');
		$pluginParams = new JRegistry();
		$pluginParams->loadString($plugin->params);
	
		$maps_id = 'ymaps-'.uniqid();
		$all = array();
		$i = 0;
		$onlycurrent = (boolean)$params->get('onlycurrent');
		$nocurrent = (boolean)$params->get('nocurrent');
		$layout      = $params->get('layout');
		
		$cur_element = $this->getItem()->getElement($this->identifier);
		$data = (array)$cur_element->data();
		$cur_element_coords = $data['location'];
		$cur_element_mapcenter = $data['mapcenter'];
		$cur_element_zoom = $data['zoom'];
		$cur_element_name = $this->getItem()->name;
		$cur_element_www = '<a href="' . $this->app->route->item($this->getItem()) . '" title="' . $this->getItem()->name . '">'.$this->getItem()->name.'</a>';
		$cur_element_more = '<a href="' . $this->app->route->item($this->getItem()) . '" title="' . $this->getItem()->name . '">Подробнее</a>';
		$cur_element_catid = $this->getItem()->getPrimaryCategory()->id;
		$cur_element_ballun = $data['ballun'];
		$cur_element_onlycurrent = $data['onlycurrentitem'];
		$cur_element_nocurrent = $data['nocurrentitem'];
		if ($layout) $cur_element_layout = $this->app->jblayout->renderItem($this->getItem(), $layout, $renderer);
		
		$file  = JString::trim($data['file']);
        $isExists = !empty($file) && JFile::exists(JPATH_ROOT . '/' . $file);
		if ($isExists) $ballunimg = '/'.$file;
		
		if ($plugin) {
			
			$elemidsarr = explode("\n", $pluginParams->get('elemids', ''));
			
			foreach ($elemidsarr as $elemid) {
				$elemidsstr = explode("#",$elemid);
				$elemids[trim($elemidsstr[0])] = trim($elemidsstr[1]);
			}
		}

		if ($cur_element_coords) {
		
		if (!$onlycurrent) {

       		foreach ($items as $item) { $i++;
				$element = $item->getElement($this->identifier);
				
				if (!$element && $plugin) {
					$element = $item->getElement($elemids[$item->type]);
				}
				
				
				if ($element) {
					$data = (array)$element->data();
					$all[$i]["coords"] = $data['location'];
					$all[$i]["ballun"] = $data['ballun'];
					$all[$i]["name"] = $item->name;
					$all[$i]["www"] = '<a href="' . $this->app->route->item($item) . '" title="' . $item->name . '">'.$item->name.'</a>';
					$all[$i]["more"] = '<a href="' . $this->app->route->item($item) . '" title="' . $item->name . '">Подробнее</a>';
					$all[$i]["catid"] = $item->getPrimaryCategory()->id;
					if ($layout) $all[$i]["ballunlayout"] = $this->app->jblayout->renderItem($item, $layout, $renderer);
					$filetmp  = JString::trim($data['file']);
        			$isExiststmp = !empty($filetmp) && JFile::exists(JPATH_ROOT . '/' . $filetmp);
					if ($isExiststmp) $all[$i]["file"] = '/'.$filetmp;
				}
        	}
		}
        $appParams = $this->getItem()->getApplication()->params;
        if ((int)$appParams->get('global.config.column_heightfix', 0)) {
            $this->app->jbassets->heightFix();
        }
	
	

	$disablemapscrollzoom = (boolean)$params->get('mapscrollzoom');
	$openbaloon = (boolean)$params->get('openbaloon');
	$imgpath = $params->get('imgpath');
	$imgpath = !empty($imgpath) ? $imgpath : '/images/';
	$imgpath = (substr($imgpath, 0) == '/' ? '' : '/').$imgpath;
	$imgpath .= (substr($imgpath, -1) == '/' ? '' : '/');
	$catimgarr = explode("\n", $params->get('catimg'));
	$clasterradius = $params->get('clasterradius');
	$clasterradius = !empty($clasterradius) ? $clasterradius : '50';

	foreach ($catimgarr as $catimgelem) {
		$catimgstr = explode("#",$catimgelem);
		$catimg[$catimgstr[0]] = trim($catimgstr[1]);
	}
	
	?>
    <div id="<?=$maps_id?>" style="width:<?=$this->config->get('width_default')?>; height:<?=$this->config->get('height_default')?>"></div>
    
<script type="text/javascript">
	
	ymaps.ready(init);
	
	function init() {
  		var customItemContentLayout = ymaps.templateLayoutFactory.createClass(
	        '<h2 class=ballon_header>{{ properties.balloonContentHeader|raw }}</h2>' +
	        '<div class=ballon_body>{{ properties.balloonContentBody|raw }}</div>' +
	        '<div class=ballon_footer>{{ properties.balloonContentFooter|raw }}</div>'
    	);
    
	    var clusterer = new ymaps.Clusterer({
    	    clusterDisableClickZoom: true,
	        clusterOpenBalloonOnClick: true,
	        clusterBalloonPanelMaxMapArea: 0,
	        clusterBalloonContentLayoutWidth: 350,
	        clusterBalloonItemContentLayout: customItemContentLayout,
	        clusterBalloonLeftColumnWidth: 120
	    });
		
		var map = new ymaps.Map('<?=$maps_id?>', {
    		center: [<?=$cur_element_mapcenter?>],
    		zoom: <?=$cur_element_zoom?>
 		});
		
		//clusterer = new ymaps.Clusterer({})
		
		<?php if ($disablemapscrollzoom) echo "map.behaviors.disable(['scrollZoom']);" ?>
		<?php if (!$onlycurrent && !$cur_element_onlycurrent) { ?>
		<?php foreach ($all as $offer) {?>
		<?php if ($offer['coords']) {?>
		clusterer.add(new ymaps.Placemark([<?=$offer['coords']?>], {
			<?php if ($layout) { ?>
				balloonContentHeader: '<?=$offer['name']?>',
				balloonContentBody: '<?=$this->js($offer['ballunlayout'])?>',
			<?php } else { ?>
            	balloonContentHeader: '<?=$offer['name']?>',
            	balloonContentBody: '<?=$offer['ballun']?>',
				balloonContentFooter: '<?=$offer['more']?>',
			<?php } ?>
            hintContent: '<?=$offer['name']?>'
        }, {
			<?php if ($offer['file']) {?>
            	iconLayout: 'default#image',
            	iconImageHref: '<?=$offer['file']?>',
			<?php } else if ($catimg[$offer['catid']]) {?>
            	iconLayout: 'default#image',
            	iconImageHref: '<?=$imgpath.$catimg[$offer['catid']]?>',
			<?php } else {?>
            preset: 'islands#icon',
            iconColor: 'blue',
			<?php } ?>
			hideIconOnBalloonOpen: false,
			balloonOffset: [3, -40]
        }))
		
		<?php } } }?>
		
		clusterer.options.set({
        	gridSize: <?=$clasterradius?>,
        	clusterDisableClickZoom: true
    	});
		
		map.geoObjects.add(clusterer);
		
		<?php if(!$nocurrent && !$cur_element_nocurrent) { ?>
		CurPlacemark = new ymaps.Placemark([<?=$cur_element_coords?>], {
            
            <?php if ($layout) { ?>
				balloonContentHeader: '<?=$cur_element_name?>',
				balloonContentBody: '<?=$this->js($cur_element_layout)?>',
			<?php } else { ?>
				balloonContentHeader: '<?=$cur_element_name?>',
				balloonContentBody: '<?=$cur_element_ballun?>',
				balloonContentFooter: '<?=$cur_element_more?>',
			<?php } ?>
			hintContent: '<?=$cur_element_name?>'
        }, {
			<?php if ($isExists) { ?>
				iconLayout: 'default#image',
				<?php if (file_exists($_SERVER['DOCUMENT_ROOT']."/".dirname($ballunimg)."/_".basename($ballunimg))) echo "iconImageHref:'".dirname($ballunimg)."/_".basename($ballunimg)."',"; else echo "iconImageHref:'".$ballunimg."'," ?>
			<?php } else if ($catimg[$cur_element_catid]) {?>
            	iconLayout: 'default#image',
				<?php if (file_exists($_SERVER['DOCUMENT_ROOT'].$imgpath."_".$catimg[$cur_element_catid])) echo "iconImageHref:'".$imgpath."_".$catimg[$cur_element_catid]."',"; else echo "iconImageHref:'".$imgpath.$catimg[$cur_element_catid]."'," ?>
			<?php } else {?>
            	preset: 'islands#icon',
            	iconColor: 'red',
			<?php } ?>
			balloonPanelMaxMapArea: 0,
			hideIconOnBalloonOpen: false,
			balloonOffset: [3, -40]
        });	
			
		map.geoObjects.add(CurPlacemark);
		
		<?php if ($openbaloon) echo "CurPlacemark.balloon.open();" ?>
		<?php } ?>
	}

</script>
    <?
    }
	}
    public function getConfigForm()
    {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__));
    }
	
}
