<?php
/**
* @package   ZOO Component
* @file      texth.php
* @version   1.0 June 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) 2013 Likrion 
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

        // no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementRepeatable class
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');
        /*
        Class: Elementversion
        */
class Elementtexth extends ElementRepeatable implements iRepeatSubmittable {

	/*
		Function: hasValue
			Checks if the element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/

	protected function _hasValue($params = array()) {
		$value     = $this->get('value', $this->config->get('default'));
		return !empty($value) || $value === '0';
	}

	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	protected function _render($params = array()) {
               $this->app->document->addStylesheet('elements:texth/assets/css/texth.css');
               $params     = $this->app->data->create($params) ;
	       $before     = $params->get('before') ;
	       $after      = $params->get('after') ;
               $value      = $this->get('value') ;
               $class      = $this->get('class') ;
               $color      = $this->get('color') ;
               $fsize      = $this->get('fsize') ;
               $fsizet     = $this->get('fsizet') ;
               $valuet     = ($this->get('valuet') != '') ? $this->get('valuet') :$this->get('value') ;
               $classt     = ($this->get('classt') != '') ? $this->get('classt') :$this->get('class') ;
               $colort     = ($this->get('colort') != '#ffffff') ? $this->get('colort'):$this->get('color') ;
               $full       = "<span class='texthf $class' style='color:$color;font-size:$fsize[0]px;vertical-align:middle'>$before $value $after</span>" ;
               $teaser     = "<span class='textht $classt' style='color:$colort;font-size:$fsizet[0]px;vertical-align:middle'>$before $valuet $after</span>" ;
          
                return ($_REQUEST['task'] == 'item') ?  $full :  $teaser;
	}

	/*
		Function: _getSearchData
			Get repeatable elements search data.

		Returns:
			String - Search data
	*/

	protected function _getSearchData() {
		return $this->get('title', $this->config->get('default'));
	}

	/*
	   Function: _edit
	       Renders the repeatable edit form field.

	   Returns:
	       String - html
	*/

        protected function _edit(){
		return $this->_editForm();
	}

	/*
		Function: _renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/

	public function _renderSubmission($params = array()) {
        return $this->_editForm($params->get('trusted_mode'));
	}

	protected function _editForm($trusted_mode = true) {
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout,
                compact('trusted_mode')
            );
        }
	}

}