<?php
/**
* @package   com_zoo
* @file      motioncaptcha.php
* @version   1.0 October 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) Likrion 2009 - 2013
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/
        // no direct access
	defined('_JEXEC') or die('Restricted access');
/*
   Class: ElementMotionCaptcha
*/
class Elementmotioncaptcha extends Element implements iSubmittable {

	/*
		Function: render
			Override. Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {


		return null;
	}

	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return null;
	}

	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {
        $this->app->document->addStylesheet('elements:motioncaptcha/assets/css/motioncaptcha.css');
        $this->app->document->addScript('elements:motioncaptcha/assets/js/motioncaptcha.js') ;

        return "<div id='mc'>
                   <canvas id='mc-canvas'>
                     Your browser doesn't support the canvas element - please visit in a modern browser.
                   </canvas>
                   <input type='hidden' id='mc-action' value='' />
                   </div>
                   <script type='text/javascript'>
                   jQuery(document).ready(function(){
                   	var act = jQuery('#item-submission').attr('action');
                        jQuery('#submit-button').hide().attr('disabled', true);
                   	jQuery('#mc-action').val(act);
                   	jQuery('#item-submission').attr('action', '#'); 
                   	jQuery('#item-submission').motionCaptcha({
                   		action: '#mc-action',
                   		divId: '#mc',
                   		cssClass: '.mc-active',
                   		canvasId: '#mc-canvas',
                   		btnRefresh: false,
                   		canvasFont: '13px \"Arial\"',
                   		canvasTextColor: '#111',
                   		errorMsg: 'Please try again.',
                   		successMsg: 'Captcha passed!',
                   		shapes: ['triangle', 'x', 'rectangle', 'circle', 'check', 'caret', 'zigzag', 'arrow', 'leftbracket', 'rightbracket', 'v', 'delete', 'star', 'pigtail'],
                   		noCanvasMsg: 'Your browser doesn\'t support <canvas> - try Chrome, FF4, Safari or IE9.',
                    		label: '<p>Please draw the shape in the box to submit the form:</p>',
                                onSuccess: function() {
                                	jQuery('#submit-button').fadeIn('fast').prop('disabled', false);
				return;
				},
                   	});
                   });
                   </script>
	";
	}


	public function validateSubmission($value, $params) {
		return null;
	}

}