<?php
/**
* @package   com_zoo
* @file      itemtimeago.php
* @version   1.0 July 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) Likrion 2009 - 2013
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

        // no direct access
defined('_JEXEC') or die('Restricted access') ;
/*
	Class: ElementItemModified
		The item modified element class
*/
class Elementitemtimeago extends Element {

	/*
		Function: hasValue
			Checks if the element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/
	public function hasValue($params = array()) {
		return true;
	}

	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return null;
	}

	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
        public function render($params = array()) {
          if (!empty ($this->_item)) {
		$params     = $this->app->data->create($params);
		$locale     = $params->get('lang');
                $format     = $params->get('format');
                $id         = $this->_item->id;
                switch($format){
                        case 'created':
                            $time = $this->_item->created;
                            break;
                        case 'modified':
                            $time = $this->_item->modified;
                            break;
                        case 'publish_up':
                            $time = $this->_item->publish_up;
                            break;
                        case 'publish_down':
                            $time = $this->_item->publish_down;
                            break;
                 }

                $this->app->document->addScript('elements:itemtimeago/assest/js/jquery.timeago.js');
                $this->app->document->addScript('elements:itemtimeago/assest/js/locale/jquery.timeago.' . $locale . '.js');
                $date =  $this->app->html->_('date', $time, $this->app->date->format('%Y-%m-%d %H:%M'), $this->app->date->getOffset());

		return $html = "<abbr id='timeago-$id' class='timeago' title='$date'>$date</abbr>";
		}
	}

}