<?php
/**
* @package   ZOO Component
* @file      eicon.php
* @version   1.0 september 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) 2013 Likrion 
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/
        // no direct access
defined('_JEXEC') or die('Restricted access');
        /*
        Class: Elementeicon
        */
class Elementeicon extends Element {

	/*
		Function: hasValue
			Checks if the element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/


	public function hasValue($params = array()) {
		return true;
	}
		/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array())
        {
            if (!empty ($this->_item)) {
                $this->app->document->addScript('elements:eicon/assets/js/eicon-glue.js');
                $this->app->document->addStylesheet('elements:eicon/assets/css/icons.css');
                
                $id	= $this->identifier;
		$icon	= $this->get('icon');
                $color  = $this->get('color');
                $fsize  = $this->get('fsize');
                $stext  = $this->get('stext');
                $other  = $this->get('other');
                $stitle = $this->get('stitle');
                $next   = $this->get('next');
             
                return "<i data-nx='$next' class='$icon[0] $other' title='$stitle' style='color:$color;font-size:$fsize[0]px;vertical-align:middle'> </i>$stext";
                }else{ 
                return null;
                }
        }

	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/

        public function edit() {
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout,
                array(
                    'element' => $this->identifier,
                    'icon'    => $this->get('icon'),
                    'color'   => $this->get('color'),
                    'fsize'   => $this->get('fsize'),
                    'stext'   => $this->get('stext'),
                    'other'   => $this->get('other'),
                    'stitle'  => $this->get('stitle'),
                    'next'    => $this->get('next')
                )
            );
        }
        return null;
	}
}