<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// init zoo
$zooPath = JPATH_ADMINISTRATOR . '/components/com_zoo/config.php';
if (JFile::exists($zooPath)) {
    require_once $zooPath;
}

/**
 * Class xmap_com_zoo
 */
class xmap_com_zoo
{

    /**
     * Simple memory cache
     * @var array
     */
    protected static $_menuItems;

    /**
     * @param $node
     */
    public static function  prepareMenuItem(& $node)
    {
        $query = parse_url($node->link);
        parse_str(html_entity_decode($query['query']), $vars);

        $component = JArrayHelper::getValue($vars, 'option', '');
        $view      = JArrayHelper::getValue($vars, 'view', '');

        if ($component == 'com_zoo' && $view == 'frontpage') {

            $id = (int)JArrayHelper::getValue($vars, 'id', 0);
            if ($id != 0) {
                $node->uid        = 'zoo' . $id;
                $node->expandible = false;
                $node->modified   = time();
            }
        }
    }

    /**
     * @param $xmap
     * @param $parent
     * @param $params
     */
    public static function getTree(&$xmap, &$parent, &$params)
    {
        $linkQuery = parse_url($parent->link);
        parse_str(html_entity_decode($linkQuery['query']), $link_vars);

        $includeCategories = JArrayHelper::getValue($params, 'include_categories', 1, '');
        $includeCategories = ($includeCategories == 1 || ($includeCategories == 2 && $xmap->view == 'xml') || ($includeCategories == 3 && $xmap->view == 'html') || $xmap->view == 'navigator');

        $includeItems = JArrayHelper::getValue($params, 'include_items', 1, '');
        $includeItems = ($includeItems == 1 || ($includeItems == 2 && $xmap->view == 'xml') || ($includeItems == 3 && $xmap->view == 'html') || $xmap->view == 'navigator');

        $params['include_categories'] = $includeCategories;
        $params['include_items']      = $includeItems;

        $priority   = JArrayHelper::getValue($params, 'cat_priority', $parent->priority, '');
        $changefreq = JArrayHelper::getValue($params, 'cat_changefreq', $parent->changefreq, '');

        if ($priority == '-1') {
            $priority = $parent->priority;
        }

        if ($changefreq == '-1') {
            $changefreq = $parent->changefreq;
        }

        $params['cat_priority']   = $priority;
        $params['cat_changefreq'] = $changefreq;

        $priority   = JArrayHelper::getValue($params, 'item_priority', $parent->priority, '');
        $changefreq = JArrayHelper::getValue($params, 'item_changefreq', $parent->changefreq, '');
        if ($priority == '-1') {
            $priority = $parent->priority;
        }

        if ($changefreq == '-1') {
            $changefreq = $parent->changefreq;
        }

        $params['item_priority']   = $priority;
        $params['item_changefreq'] = $changefreq;

        self::getCategoryTree($xmap, $parent, $params);
    }

    /**
     * @param $xmap
     * @param $parent
     * @param $params
     */
    public static function getCategoryTree(&$xmap, &$parent, &$params)
    {
        $db   = JFactory::getDBO();
        $menu = JFactory::getApplication()->getMenu();
        
        if (!is_array($params)) {
            $params = array();
        }
        
        $params['app_exclude'] = isset($params['app_exclude']) ? $params['app_exclude'] : '';
        $params['cat_exclude'] = isset($params['cat_exclude']) ? $params['cat_exclude'] : '';
        
        $appExclude = explode(' ', $params['app_exclude']);
        $catExclude = explode(' ', $params['cat_exclude']);

        // first we fetch what application we are talking about
        $menuparams = $menu->getParams($parent->id);
        $appid      = intval($menuparams->get('application', 0));

        if ($params['include_categories']) {

            // get categories info from database
            $db->setQuery(
                'SELECT c.id, c.name ' .
                'FROM #__zoo_category AS c ' .
                ' WHERE c.application_id = ' . (int)$appid . ' AND c.published=1 ' .
                ' ORDER by c.ordering'
            );

            $cats = $db->loadObjectList();

            // now we print categories
            $xmap->changeLevel(1);
            foreach ($cats as $cat) {
                
                $Itemid = 0;
                
                $menuItem = self::_find('frontpage', $appid);
                if (!$menuItem) {
                    $Itemid = self::_find('category', $appid)->id;
                }

                if (!isset($Itemid)) {
                    $Itemid = JFactory::getApplication()->app->getMenu()->getDefault()->id;
                }
                
                if ($Itemid) {
                    $node             = new stdclass;
                    $node->id         = $parent->id;
                    $node->uid        = $parent->uid . 'c' . $cat->id;
                    $node->name       = $cat->name;
                    $node->link       = 'index.php?option=com_zoo&amp;task=category&amp;category_id=' . $cat->id . '&amp;Itemid=' . $Itemid;
                    $node->priority   = $params['cat_priority'];
                    $node->changefreq = $params['cat_changefreq'];
                    $node->modified   = time();
                    $node->expandible = true;
                    $xmap->printNode($node);
                }
            }
            $xmap->changeLevel(-1);
        }

        if ($params['include_items']) {

            $queryi = 'SELECT tItem.id, tItem.name, tItem.modified, tItem.application_id, tItem.params' .
                ' FROM #__zoo_item AS tItem' .
                ' WHERE tItem.application_id= ' . (int)$appid .
                ' AND tItem.state = 1' .
                ' AND DATEDIFF( tItem.publish_up, NOW( ) ) <=0' .
                ' AND IF( tItem.publish_down >0, DATEDIFF( tItem.publish_down, NOW( ) ) >0, true )' .
                ' ORDER BY tItem.publish_up';

            $db->setQuery($queryi);
            $items = $db->loadObjectList();

            $app       = App::getInstance('zoo');
            $itemTable = $app->table->item;
            $zooRoute  = $app->route;

            // now we print items
            $xmap->changeLevel(1);
            foreach ($items as $item) {

                if (in_array($item->application_id, $appExclude)) {
                    continue;
                }

                $itemParams = (array)json_decode($item->params);
                if (isset($itemParams['config.primary_category'])) {
                    if (in_array($itemParams['config.primary_category'], $catExclude)) {
                        continue;
                    }
                }

                if (!($Itemid = self::_find('frontpage', $appid)->id) &&
                    !($Itemid = self::_find('category', $appid)->id)
                ) {
                    $Itemid = self::_find('item', $appid)->id;
                }

                $rootUrl = JUri::root();

                if ($Itemid) {

                    $zooItem = $itemTable->get($item->id);
                    $itemUrl = $zooRoute->item($zooItem);
                    if (strpos($itemUrl, $rootUrl) !== 0) {
                        $itemUrl = $rootUrl . ltrim($itemUrl, '/');
                    }

                    $node             = new stdclass;
                    $node->id         = $parent->id;
                    $node->uid        = $parent->uid . 'i' . $item->id;
                    $node->name       = $item->name;
                    $node->link       = $itemUrl;
                    $node->priority   = $params['item_priority'];
                    $node->changefreq = $params['item_changefreq'];
                    $node->expandible = true;
                    $node->modified   = strtotime($item->modified);
                    $node->newsItem   = 1;
                    $xmap->printNode($node);
                }

            }
            $xmap->changeLevel(-1);
        }
    }

    /**
     * Find object url and save it to memory fo speed
     * @param $type
     * @param $id
     * @return mixed
     */
    protected static function _find($type, $id)
    {
        $app = App::getInstance('zoo');

        if (self::$_menuItems == null) {

            $menuItems = $app->object->create('JSite')
                ->getMenu()
                ->getItems('component_id', JComponentHelper::getComponent('com_zoo')->id);

            $menuItems = $menuItems ? $menuItems : array();

            self::$_menuItems = array_fill_keys(array('category', 'frontpage', 'item'), array());

            foreach ($menuItems as $menuItem) {

                $view = isset($menuItem->query['view']) ? $menuItem->query['view'] : null;

                switch ($view) {

                    case 'frontpage':
                        self::$_menuItems['frontpage'][$app->parameter->create($menuItem->params)->get('application')] = $menuItem;
                        break;

                    case 'category':
                        self::$_menuItems['category'][$app->parameter->create($menuItem->params)->get('category')] = $menuItem;
                        break;

                    case 'item':
                        self::$_menuItems['item'][$app->parameter->create($menuItem->params)->get('item_id')] = $menuItem;
                        break;
                }
            }
        }

        if (isset(self::$_menuItems[$type][$id])) {
            return self::$_menuItems[$type][$id];
        }

        return (object)array('id' => 0);
    }

}