<?php

defined('_JEXEC') or die('Restricted access');
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

class Elementaccordionj extends ElementRepeatable implements iRepeatSubmittable {

	protected function _hasValue($params = array()) {
		$link = $this->get('value', '');
		return !empty($link);
	}

	public function getText() {
		$text = $this->get('text', '');
		return empty($text) ? $this->get('value', '') : $text;
	}


	protected function _render($params = array()) {
                    
                $this->app->document->addStylesheet('elements:accordionj/accordionj.css');
                $this->app->system->document->addScript('http://html5shim.googlecode.com/svn/trunk/html5.js');
                $this->app->system->document->addScript('http://code.jquery.com/jquery-latest.js');
                $this->app->document->addScript('elements:accordionj/accordionj.js');
                $id = $this->key();


	return
$html[] ='<section id="'.$id.'">
<h2><a href="#'.$id.'">'.$this->get('value', '').'</a></h2>
<div><p>'.$this->getText().'</p></div>
</section>';
	}

	protected function _edit(){
		return $this->_editForm();
	}

	public function _renderSubmission($params = array()) {
        return $this->_editForm($params->get('trusted_mode'));
	}

	protected function _editForm($trusted_mode = true) {
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout,
                compact('trusted_mode')
            );
        }
	}

	public function _validateSubmission($value, $params) {
        $values       = $value;
        $validator    = $this->app->validator->create('string', array('required' => false));
        $text         = $validator->clean($values->get('text'));
        $value        = $this->app->validator
				->create('url', array('required' => $params->get('required')), array('required' => 'Please enter block\'s header'))
				->clean($values->get('value'));

		return compact('value', 'text');
    }

}