<?php
/**
 * @package     Social Buttons Module
 * @subpackage  mod_social_buttons
 *
 * @copyright   Copyright (C) 2014 Yanovskiy Vitaliy All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
?>
<?php if(isset($buttons['bookmarks']) && !empty($buttons['bookmarks'])) : ?>
<div class="bookmarks">
    <?php foreach ($buttons['bookmarks'] as $name => $data) : ?>
    <?php

    if ($name == "email") {
        $title = JText::_('BOOKMARK_RECOMMENDED_THIS_PAGE_TO');
    } else {
        $title = JText::_('BOOKMARK_ADD_THIS_PAGE_TO') . ' ' . $data['label'];
    }
    ?>

    <a class="<?php echo $name ?>" onclick="<?php echo $data['click']; ?>" href="<?php echo $data['link']; ?>"
       title="<?php echo $title; ?>"></a>
<?php endforeach; ?>
</div>
<?php endif;

    if(!empty($buttons['likes']['fbOption']) ||
        !empty($buttons['likes']['twOption']) ||
        !empty($buttons['likes']['okOption']) ||
        !empty($buttons['likes']['gpOption']) ||
        !empty($buttons['likes']['liOption']) ||
        !empty($buttons['likes']['vkOption'])):?>
    <div class="likes">

        <?php if (isset($buttons['likes']['fbOption']['fbEnabled'])) : ?>
            <!-- Render FB button -->
            <div class="like like-fb">
                <div id="<?php echo $buttons['likes']['fbOption']['fbId'] ?>"></div>
                <script>
                    jQuery(function ($) {
                        (function (d, s, id) {
                            var js, fjs = d.getElementsByTagName(s)[0];
                            if (d.getElementById(id)) return;
                            js = d.createElement(s);
                            js.id = id;
                            js.src = "<?php echo $buttons['likes']['fbOption']['data-src'] ?>";
                            fjs.parentNode.insertBefore(js, fjs);
                        }(document, 'script', 'facebook-jssdk'));
                    });
                </script>
                <div <?php echo $buttons['likes']['fbOption']['params'] ?>></div>
            </div>
        <?php endif ?>



        <?php if (isset($buttons['likes']['twOption']['twEnabled'])) : ?>
            <!-- Render TW button -->
            <div class="like like-tw">
                <a <?php echo $buttons['likes']['twOption']['params'] ?>><?php echo JText::_('JBZOO_LIKE_TW') ?></a>
                <script>
                    jQuery(function ($) {
                        !function (d, s, id) {
                            var js, fjs = d.getElementsByTagName(s)[0];
                            if (!d.getElementById(id)) {
                                js = d.createElement(s);
                                js.id = id;
                                js.src = "http://platform.twitter.com/widgets.js";
                                fjs.parentNode.insertBefore(js, fjs);
                            }
                        }(document, "script", "twitter-wjs");
                    });
                </script>
            </div>
        <?php endif ?>



        <?php if (isset($buttons['likes']['okOption']['okEnabled'])) : ?>
            <!-- Render OK button -->
            <div class="like like-ok">
                <div id="<?php echo $buttons['likes']['okOption']['okId'] ?>"></div>
                <script>
                    !function (d, id, did, st) {
                        var js = d.createElement("script");
                        js.src = "http://connect.ok.ru/connect.js";
                        js.onload = js.onreadystatechange = function () {
                            if (!this.readyState || this.readyState == "loaded" || this.readyState == "complete") {
                                if (!this.executed) {
                                    this.executed = true;
                                    setTimeout(function () {
                                        OK.CONNECT.insertShareWidget(id, did, st);
                                    }, 0);
                                }
                            }
                        };
                        d.documentElement.appendChild(js);
                    }(document, '<?php echo $buttons['likes']['okOption']['okId'] ?>', '<?php echo $buttons['likes']['okOption']['okUrl'] ?>',
                            '<?php echo json_encode($buttons['likes']['okOption']['params']) ?>');
                </script>
            </div>
        <?php endif ?>


        <?php if (isset($buttons['likes']['gpOption']['gpEnabled'])) : ?>
            <!-- Render Google+ button -->
            <div class="like like-gp">
                <div <?php echo $buttons['likes']['gpOption']['params'] ?>></div>
                <script type="text/javascript">
                    window.___gcfg = <?php echo json_encode($buttons['likes']['gpOption']['scriptParams']) ?>;
                    (function () {
                        var po = document.createElement('script');
                        po.type = 'text/javascript';
                        po.async = true;
                        po.src = 'https://apis.google.com/js/plusone.js';
                        var s = document.getElementsByTagName('script')[0];
                        s.parentNode.insertBefore(po, s);
                    })();
                </script>
            </div>
        <?php endif ?>



        <?php if (isset($buttons['likes']['liOption']['liEnabled'])) : ?>
            <!-- Render LI button -->
            <div class="like like-li">
                <script src="//platform.linkedin.com/in.js" type="text/javascript">
                    lang:<?php echo $buttons['likes']['liOption']['lang'] ?>
                </script>
                <script type="IN/Share" <?php echo $buttons['likes']['liOption']['params'] ?>></script>
            </div>
        <?php endif ?>


        <?php if (isset($buttons['likes']['vkOption']['vkEnabled']) && !empty($buttons['likes']['vkOption']['id'])) : ?>
            <!-- Render VK button -->
            <div class="like like-vk">
                <div id="<?php echo $buttons['likes']['vkOption']['vkId'] ?>"></div>
                <script type="text/javascript">
                    jQuery(function ($) {
                        VK.init({apiId: <?php echo $buttons['likes']['vkOption']['id'] ?>, onlyWidgets: true});
                        VK.Widgets.Like(
                            "<?php echo $buttons['likes']['vkOption']['vkId'] ?>",
                            <?php echo json_encode($buttons['likes']['vkOption']['params']);?>,
                            <?php echo $buttons['likes']['vkOption']['pageId'] ?>
                        );
                    });
                </script>
            </div>
        <?php endif ?>

    </div>
<?php endif;

if (isset($buttons['complex']['yaOption']['yaEnabled'])) : ?>

    <div class="share">
        <div id="<?php echo $buttons['complex']['yaOption']['element']; ?>"></div>

        <script type="text/javascript">
            new Ya.share(<?php echo json_encode($buttons['complex']['yaOption']); ?>);
        </script>

    </div>

<?php endif;