
var ZooYaMap =
{
    map: null,
    collection: null,
    mapEl: null,
    action: 'index.php?option=com_ajax&format=json&module=zoomap',
    items: false,
    num: 0,
    plus: null,
    center:[53.9059595669828,27.554930095523527],
    zoom:8,
    uri: window.location.href,
    his: !!(window.history && history.pushState),
    init: function(center,zoom,items)
    {
        var self = this, $ = jQuery;

        if(center){
            self.center = [center.split(',')[0],center.split(',')[1]];
        }

        if( zoom){
            self.zoom    = zoom;
        }


        ymaps.ready(function() {
            self.map = new ymaps.Map("ya-map", {
                center: self.center,
                zoom: self.zoom,
                behaviors: ["default"]
            });

            self.map.behaviors.enable('dblClickZoom');
            self.map.controls.add(new ymaps.control.ZoomControl());
            self.mapEl = $('#ya-map');

            self.collection = new ymaps.GeoObjectCollection();

            if(items){
                self.addItems(items);
            }

        });

    },

    addItems: function (items, plus) {

        var self = this;
        items = jQuery.parseJSON(items);
        if(!this.items) this.items = [];

        for(var i = 0;i<items.length;i++)
        {
            self.addItem(items[i],i);
        }
        self.map.geoObjects.add(self.collection);

        if(items.length>1) {
            self.map.setBounds(self.collection.getBounds());
        } else {
            if(items.length) {
                self.map.setCenter(items[0][0],self.zoom?self.zoom:11);
            } else {
                self.map.setCenter(self.center, 10);
            }

        }

    },


    addItem: function (data,i) {
        var self = this;
		// очистить переменну надо
		var myhint = data[1];
        
		self.items[i] = new ymaps.Placemark(data[0], 
		{	hintContent: myhint}, 
		{
            // Опции.
            iconImageHref: '/stories/images/icons/map_m.png', // картинка иконки
            iconImageSize: [43, 71], 
            iconImageOffset: [-22, -60] 
        }
			);
        self.items[i].events.add('click', function (e){
            var m = e.get('target');
            if(!m.properties.get('balloonContentBody'))
                self.post({id:m.id,Itemid:data[3]}, function(r) {
                    m.properties.set({balloonContentBody:r.data.body});
                    m.balloon.open();
                });
        });
        self.items[i].id = data[2];
        self.collection.add(self.items[i]);

    },

    setCookie: function (name, v, days) {
        if(v == null)
            return document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
        var today = new Date();
        var expire = new Date();
        expire.setTime(today.getTime() + 3600000*24*(days==null || days==0 ? 1000 : days));
        document.cookie = name+"="+v+";expires="+expire.toGMTString();
    },

    round: function (n, d) {
        var m = Math.pow(10, d);
        return Math.round(n * m) / m;
    },

    post: function (data, callback) {

        return jQuery.post(this.action, data, function(r) {
            callback(r)
        });
    }
};

