<?php
/**
 * @package     Joomla.Tutorials
 * @subpackage  Module
 * @license     License GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die('(@)|(@)');

class modZoomapHelper
{

        public static function getAjax() {

                $params = array();

                $app = App::getInstance('zoo');

                $item_id = (int) $app->request->getInt('id', 0);

                $item = $app->table->item->get($item_id);

                $renderer = $app->renderer->create('item')->addPath(array($app->path->path('component.site:'), dirname(__FILE__)));

                return array('body'=>modZoomapHelper::relToAbs($renderer->render('item.default', compact('item', 'params'))));

        }




    public static function getFilterMarkers($params,$renderer){



        $app = App::getInstance('zoo');

        $type     = $app->jbrequest->get('type');
        $logic    = strtoupper($app->jbrequest->getWord('logic', 'and'));
        $exact    = (int)$app->jbrequest->get('exact', 0);
        $elements = $app->jbrequest->getElements();
        $appId    = $app->jbrequest->get('app_id');

        // search!
        $searchModel = JBModelFilter::model();
        $items       = $searchModel->search($elements, $logic, $type, $appId, $exact, 0, 999);

        $markers = array();

        foreach ($items as $item) {

            $elements = $item->getElements();
            foreach ($elements as $element) {
                if (($element->getElementType() == 'yamap') && $element->hasValue()) {
                    foreach($element->data() as $value){

                        $coordinatesArr     =  explode(',',$value["coordinates"]);
                        $lng                = trim($coordinatesArr[1]);
                        $lat                = trim($coordinatesArr[0]);
						$name 				= htmlspecialchars(($item->name),ENT_QUOTES);
                        $markers[] = array(array($lat, $lng), $name, $item->id,JFactory::getApplication()->getMenu()->getActive()->id);

                    }
                }
            }
        }

        return $markers;

    }


        public static function getMarkers($params,$renderer){

                $app = App::getInstance('zoo');

                $category_id = $params->get('category_id');

                $conditions =" a.state = 1 "
                    .($params->get('application') ? " AND a.application_id = ".$params->get('application') : '')
                    .($category_id ? " AND cc.category_id ".(is_array($category_id) ? ' IN ('.implode(',', $category_id).')' : ' = '.$category_id) : '')
                    ." GROUP BY a.id";

                $options = array(
                    'select' => "a.*",
                    'from' => "#__zoo_item AS a"
                        .($category_id  ? " LEFT JOIN #__zoo_category_item as cc on a.id=cc.item_id" : ""),
                    'conditions' => $conditions);

                $items = $app->table->item->all($options);

                foreach ($items as $item) {

                        $elements = $item->getElements();
                        foreach ($elements as $element) {
                                if (($element->getElementType() == 'yamap') && $element->hasValue()) {
                                        foreach($element->data() as $value){

                                                $coordinatesArr     =  explode(',',$value["coordinates"]);
                                                $lng                = trim($coordinatesArr[1]);
                                                $lat                = trim($coordinatesArr[0]);
												$name 				= htmlspecialchars(($item->name),ENT_QUOTES);
                                                //$text = modZoomapHelper::relToAbs($renderer->render('item.'. str_replace('_:','',$params->get('layout', 'default')), compact('item', 'params')));
                                                $markers[] = array(array($lat, $lng), $name, $item->id,JFactory::getApplication()->getMenu()->getActive()->id);

                                        }
                                }
                        }
                }
                return $markers;

        }

        public static function relToAbs($text){
                // convert relative to absolute url
                $base = JURI::base();
                $text = preg_replace("/(href|src)=\"(?!http|ftp|https|mailto)(?!\/)([^\"]*)\"/", "$1=\"$base\$2\"", $text);
                $base = JURI::getInstance()->toString(array('scheme', 'user', 'pass', 'host', 'port'));
                $text = preg_replace("/(href|src)=\"(?!http|ftp|https|mailto)([^\"]*)\"/", "$1=\"$base\$2\"", $text);
                return $text;
        }

}
