<?php
/**
 * @package     Joomla.Tutorials
 * @subpackage  Module
 * @license     License GNU General Public License version 2 or later; see LICENSE.txt
 */ 

// No direct access.
defined('_JEXEC') or die('(@)|(@)');

// load config
require_once(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
// get app
$zoo = App::getInstance('zoo');
// init vars
$path = dirname(__FILE__);
//register base path
$zoo->path->register($path, 'mod_zoomap');

require_once dirname(__FILE__).'/helper.php';

if ($application = $zoo->table->application->get($params->get('application'))) {

    $renderer = $zoo->renderer->create('item')->addPath(array($zoo->path->path('component.site:'), dirname(__FILE__)));


    if($params->get('filter',1)){

        require_once(JPATH_BASE . '/media/zoo/applications/jbuniversal/framework/jbzoo.php');
        JBZoo::init();

        $task = $zoo->jbrequest->get('task');
        $option = $zoo->jbrequest->get('option');

        if($task=='filter'&&$option=='com_zoo'){
            $markers = modZoomapHelper::getFilterMarkers($params,$renderer);

        }else{
            $markers = modZoomapHelper::getMarkers($params,$renderer);
        }

    } else {
        $markers = modZoomapHelper::getMarkers($params,$renderer);
    }







    $center = trim($params->get('center',''));

    $zoom = trim($params->get('zoom',''));

    $width = trim($params->get('width','500px'));

    $height =    trim($params->get('height','400px'));

    require JModuleHelper::getLayoutPath('mod_zoomap', $params->get('layout', 'default'));

}