<?php
/**
* @package   com_zoo
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

/*
   Class: ElementItemCategory
       The item category element class
*/

class ElementYaMap extends Element implements iSubmittable {


    /*
	   Function: Constructor
	*/
    public function __construct() {

        // call parent constructor
        parent::__construct();
    }


    /*
		Function: bindData
			Set data through data array.

		Parameters:
			$data - array

		Returns:
			Void
	*/
    public function bindData($data = array()) {
        parent::bindData($data);
    }

    /*
        Function: hasValue
            Checks if the element's value is set.

       Parameters:
            $params - render parameter

        Returns:
            Boolean - true, on success
    */
	public function hasValue($params = array()) {
        $value = $this->get('value');
		return $value["coordinates"] ? true : false;
	}

	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {

        $params = $this->app->data->create($params);

        $value = $this->get('value');


        if(!empty($value)){

            $center_type        = $value["center_type"];

            $coordinatesArr     =  explode(',',$value["coordinates"]);

            $lng                = trim($coordinatesArr[1]);
            $lat                = trim($coordinatesArr[0]);
            $location           = $value["location"];
            $coordinates        = $value["coordinates"];

            $zoom               = $value["zoom"];
            $centerArr          =  explode(',',$value["center"]);

            if($center_type=='point'){
                $center_lng         = $lng;
                $center_lat         = $lat;
            } else{
                $center_lng         = trim($centerArr[1]);
                $center_lat         = trim($centerArr[0]);
            }





            // render layout
            if ($layout = $this->getLayout()) {
                $this->loadAssets();
                return $this->renderLayout($layout, compact('params','location','coordinates','center_lng','center_lat','lng','lat','zoom'));
            }
        }

        return null;

	}

	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit($params = array()) {

        $this->loadAssets();

        $params = $this->app->data->create($params);

        $value = $this->get('value');




        $coordinatesArr     =  explode(',',$value["coordinates"]);

        $lng                = trim($coordinatesArr[1]);
        $lat                = trim($coordinatesArr[0]);
        $location           = $value["location"];
        $coordinates        = $value["coordinates"];

        $zoom               = $value["zoom"];
        $centerArr          =  explode(',',$value["center"]);

        $center_lng         = trim($centerArr[1]);
        $center_lat         = trim($centerArr[0]);

        $center_type        = $value["center_type"];




        // render layout
        if ($layout = $this->getLayout('edit.php')) {
            $this->loadAssets();
            return $this->renderLayout($layout, compact('params','location','coordinates','center_lng','center_lat','lng','lat','zoom','center_type'));
        }

	}

    public function loadAssets() {
        parent::loadAssets();
        $doc = JFactory::getDocument();
        $doc->addScript('http://api-maps.yandex.ru/2.0/?load=package.full&lang=ru-RU');
        $this->app->document->addScript('elements:yamap/assets/js/yamap.js');
        $this->app->document->addStylesheet('elements:yamap/assets/css/yamap.css');

    }

	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {

        if( $this->_item->id) return $this->edit();

        $this->loadAssets();

        $params = $this->app->data->create($params);

        $center_lng = null;
        $center_lat = null;

        // render layout
        if ($layout = $this->getLayout('submission.php')) {
            return $this->renderLayout($layout, compact('params','center_lng','center_lat'));
        }

	}

	/*
		Function: validateSubmission
			Validates the submitted element

	   Parameters:
            $value  - AppData value
            $params - AppData submission parameters

		Returns:
			Array - cleaned value
	*/
    public function validateSubmission($value, $params)
    {
        return $value;
    }


}