<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


$db = JFactory::getDbo();
$query = $db->getQuery(true)
    ->select('a.id AS value')
    ->select('a.title AS text')
    ->select('COUNT(DISTINCT b.id) AS level')
    ->from('#__usergroups as a')
    ->join('LEFT', '#__usergroups  AS b ON a.lft > b.lft AND a.rgt < b.rgt')
    ->group('a.id, a.title, a.lft, a.rgt')
    ->order('a.lft ASC');
$db->setQuery($query);

$data = array();
if ($options = $db->loadObjectList()) {
    foreach ($options as &$option) {
        $data[$option->value] = str_repeat('- ', $option->level) . $option->text;
    }
}

echo $this->app->jbhtml->select($data, $control_name . '[' . $name . ']', array('multiple' => 'multiple', 'size' => 10), $value);
