<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCartElementHookChangegroup
 */
class JBCartElementHookChangegroup extends JBCartElementHook
{

    /**
     * @param $params
     */
    public function notify($params = array())
    {
        $user = $this->getOrder()->getAuthor();

        if ($user && $user->id) {

            $values = (array)$this->config->get('add_group', array());
            $newGroups = array_combine($values, $values);

            if ($this->config->get('merge', 1)) {
                $newGroups = $newGroups + (array)$user->groups;
            }

            JUserHelper::setUserGroups($user->id, $newGroups);
        }

    }

    /**
     * @return AppParameterForm
     */
    public function getConfigForm()
    {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__));
    }

}
