<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBExportJBuniversalController
 * JBZoo export controller for back-end
 */
class JBExportJBuniversalController extends AppController
{
    /**
     * @var string
     */
    protected $_viewsPath = '';

    /**
     * Constructor
     * @param array $default
     */
    public function __construct($default = array())
    {
        parent::__construct($default);
        $this->app->jbrequest->set('tmpl', 'component');

        $this->baseurl    = $this->app->link(array('controller' => $this->controller), false);
        $this->_viewsPath = $this->app->path->path('jbviews:');
    }

    /**
     * Export dialog action
     */
    public function index()
    {
        include $this->_viewsPath . '/import-export/export.tpl.php';
    }

    /**
     * Export process action
     */
    public function exportProcess()
    {
        $request = $this->app->data->create($this->app->jbrequest->get('jbzooform'));
        $this->app->jbuser->setParam('export', $request);

        try {
            $this->app->jbexport->clean();

            $itemsFiles = $categoriesFiles = array();
            if ((int)$request->get('items')) {
                list($appId, $catId) = explode(':', $request->get('items_app_category', '0:0'));
                $itemsFiles = $this->app->jbexport->itemsToCSV(
                    $appId,
                    $catId,
                    $request->get('type', null),
                    $request
                );
            }

            if ((int)$request->get('categories')) {
                list($appId) = explode(':', $request->get('category_app', '0:'));
                $categoriesFiles = $this->app->jbexport->categoriesToCSV($appId, $request);
            }

            $files = $itemsFiles + $categoriesFiles;

            if (empty($files)) {
                $this->setRedirect(
                    $this->app->jbrouter->admin(array('task' => 'index', 'controller' => 'jbimport')),
                    JText::_('JBZOO_EXPORT_ITEMS_NOT_FOUND')
                );
                return;

            } else {
                $tmpArch = $this->app->jbarch->compress($files, 'jbzoo-export-' . date('Y-m-d_H-i'));
            }

            if (is_readable($tmpArch) && JFile::exists($tmpArch)) {
                $this->app->filesystem->output($tmpArch);
                JFile::delete($tmpArch);
                JFolder::delete(JPATH_ROOT . '/tmp/jbzoo-export');
                jexit();
            } else {
                throw new AppException(JText::sprintf('Unable to create file %s', $tmpArch));
            }

        } catch (AppException $e) {
            // raise error on exception
            $this->app->error->raiseNotice(0, JText::_('Error create report') . ' (' . $e . ')');
            $this->setRedirect($this->app->jbrouter->admin(array('task' => 'export', 'controller' => 'jbexport')));

            return;
        }
    }

}

/**
 * Class ExceptionJBExportJBuniversalController
 */
class ExceptionJBExportJBuniversalController extends AppException
{

}
