<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBImportJBuniversalController
 * JBZoo import controller for back-end
 */
class JBImportJBuniversalController extends AppController
{
    /**
     * @var string
     */
    protected $_viewsPath = '';

    /**
     * @var JBImportHelper
     */
    protected $_jbimport = null;

    /**
     * @var JBSessionHelper
     */
    protected $_jbsession = null;

    /**
     * @var JBRequestHelper
     */
    protected $_jbrequest = null;

    /**
     * Constructor
     * @param array $default
     */
    public function __construct($default = array())
    {
        parent::__construct($default);

        // no layout!
        $this->app->jbrequest->set('tmpl', 'component');

        // some vars
        $this->baseurl    = $this->app->link(array('controller' => $this->controller), false);
        $this->_viewsPath = $this->app->path->path('jbviews:');

        // get helpers
        $this->_jbimport  = $this->app->jbimport;
        $this->_jbsession = $this->app->jbsession;
        $this->_jbrequest = $this->app->jbrequest;
    }

    /**
     * Import dialog action
     */
    public function index()
    {
        $this->_jbsession->clearGroup('import');

        // get prev export params
        $exportParams = $this->app->jbuser->getParam('export', array());

        // get prev import params
        $defaultImportParams = array(
            'header'    => 1,
            'separator' => ',',
            'enclosure' => '"'
        );

        $importItemsParams      = $this->app->jbuser->getParam('import-items', $defaultImportParams);
        $importCategoriesParams = $this->app->jbuser->getParam('import-categories', $defaultImportParams);

        include $this->_viewsPath . '/import-export.tpl.php';
    }

    /**
     * Import dialog action
     */
    public function assign()
    {
        $csvfile = $this->_jbrequest->getFile('csvfile', 'jbzooform');

        // validate upload file
        try {
            $userfile = $this->app->validator->create('file', array('extension' => array('csv')))->clean($csvfile);
        } catch (AppException $e) {
            $this->app->error->raiseNotice(0, JText::_('JBZOO_UNABLE_TO_UPLOAD_FILE') . ' (' . $e . ')');
            $this->setRedirect($this->baseurl . '&task=index');
            return;
        }

        // upload file
        $file = $this->_jbimport->getTmpFilename();
        if (JFile::upload($userfile['tmp_name'], $file)) {

            // prepare session data
            $request    = $this->_jbrequest->getArray('jbzooform');
            $importType = isset($request['import-type']) ? $request['import-type'] : null;
            $this->app->jbuser->setParam('import-' . $importType, $request);

            $request['file'] = $file;

            // save to session
            $this->_jbsession->setGroup($request, 'import');

            // prepare data
            $info = $this->_jbimport->getInfo($file, $request);
            $this->_jbsession->set('count', $info['count'], 'import');

            // render pseudo template
            if ($importType == 'items') {

                // some vars for template
                $controls   = $this->_jbimport->itemsControls($info);
                $prevParams = $this->app->jbuser->getParam('lastImport-items');

                include $this->_viewsPath . '/import-export/items-assign.tpl.php';

            } else if ($importType == 'categories') {

                // some vars for template
                $controls   = $this->_jbimport->categoriesControls($info);
                $prevParams = $this->app->jbuser->getParam('lastImport-categories');

                include $this->_viewsPath . '/import-export/categories-assign.tpl.php';
            } else {
                jexit('Unknown import type!'); // TODO replace to exception
            }

        } else {
            $this->app->error->raiseNotice(0, JText::_('JBZOO_CHECK_TEMP_PERMISIONS'));
            $this->setRedirect($this->baseurl . '&task=index');
            return;
        }
    }

    /**
     * Show steps
     */
    public function itemsSteps()
    {
        $appid        = (int)$this->_jbrequest->get('appid');
        $typeid       = $this->_jbrequest->get('typeid');
        $checkOptions = $this->_jbrequest->get('checkOptions');
        $lose         = $this->_jbrequest->get('lose');
        $key          = $this->_jbrequest->get('key');
        $assign       = $this->_jbrequest->getArray('assign');

        if (empty($appid) || empty($typeid) || !isset($assign[$typeid]) || empty($assign[$typeid])) {
            $this->app->error->raiseNotice(0, JText::_('JBZOO_INCORRECT_DATA'));
            $this->setRedirect($this->baseurl . '&task=index');
        }

        $data = array(
            'appid'        => $appid,
            'typeid'       => $typeid,
            'lose'         => $lose,
            'key'          => $key,
            'checkOptions' => $checkOptions,
            'assign'       => $assign[$typeid],
        );

        $this->_jbsession->setBatch($data, 'import');

        // save to user params
        $params          = (array)$this->app->jbuser->getParam('lastImport-items', array());
        $params[$typeid] = $assign[$typeid];
        unset($data['assign']);
        $params['previousParams'] = $data;
        $this->app->jbuser->setParam('lastImport-items', $params);

        // render pseudo template
        include $this->_viewsPath . '/import-export/items-steps.tpl.php';
    }

    /**
     * Categories steps action
     */
    public function categoriesSteps()
    {
        $appid  = (int)$this->_jbrequest->get('appid');
        $lose   = $this->_jbrequest->get('lose');
        $key    = $this->_jbrequest->get('key');
        $assign = $this->_jbrequest->getArray('assign');

        if (empty($appid) || empty($assign)) {
            $this->app->error->raiseNotice(0, JText::_('JBZOO_INCORRECT_DATA'));
            $this->setRedirect($this->baseurl . '&task=index');
        }

        $data = array(
            'appid'  => $appid,
            'lose'   => $lose,
            'key'    => $key,
            'assign' => $assign,
        );

        $this->_jbsession->setBatch($data, 'import');

        // save to user params
        $this->app->jbuser->setParam('lastImport-categories', $data);

        // render pseudo template
        include $this->_viewsPath . '/import-export/categories-steps.tpl.php';
    }

    /**
     * One ajax step for items import
     */
    public function ajax()
    {
        try {

            $importType = $this->_jbrequest->get('import-type');
            $page       = (int)$this->_jbrequest->get('page');
            $result     = array();

            if ($importType == 'items') {
                $result = $this->_jbimport->itemsProcess($page);

            } else if ($importType == 'categories') {
                $result = $this->_jbimport->categoriesProcess($page);

            }

            $this->app->jbajax->send($result);

        } catch (Exception $e) {
            //echo $e->getTraceAsString();
            jexit("Exception: " . $e->getMessage());
        }
    }

    /**
     * Call after all items loaded
     */
    public function postAjax()
    {
        try {
            $importType = $this->_jbrequest->get('import-type');

            if ($importType == 'items') {
                $this->_jbimport->itemsPostProcess();

            } else if ($importType == 'categories') {
                $this->_jbimport->categoriesPostProcess();
            }

            $data = $this->app->jbsession->getGroup('import');
            if (JFile::exists($data['file'])) {
                JFile::delete($data['file']);
            }

            $this->app->jbajax->send();

        } catch (Exception $e) {
            //echo $e->getTraceAsString();
            jexit("Exception: " . $e->getMessage());
        }
    }

}

/**
 * Class ExceptionJBImportJBuniversalController
 */
class ExceptionJBImportJBuniversalController extends AppException
{

}
