<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


?>
<div class="jbzoo">
    <form class="jbzoo-import-fields jbadminform" method="post"
          action="index.php" name="jbzooimport" id="jbzooimport" enctype="multipart/form-data">

        <div class="box-bottom">

            <h2><?php echo JText::_('JBZOO_IMPORT_FIELDS'); ?></h2>


            <fieldset class="items">

                <input type="submit" name="send" value="<?php echo JText::_('JBZOO_FORM_IMPORT'); ?>"
                       style="float: right;margin-right: 16px;"/>

                <div class="clr clearfix"></div>

                <div class="assign-group">

                    <div class="info">
                        <label for="appid"><?php echo JText::_('JBZOO_IMPORT_CHOOSE_APP'); ?></label>
                        <?php echo $controls['apps']; ?>
                    </div>

                    <div class="info">
                        <label for="typeid"><?php echo JText::_('JBZOO_IMPORT_CHOOSE_TYPE'); ?></label>
                        <?php echo $controls['types']; ?>
                    </div>

                    <div class="info">
                        <label for="key"><?php echo JText::_('JBZOO_IMPORT_KEY'); ?></label>
                        <?php echo $controls['key']; ?>
                    </div>

                    <div class="info">
                        <label for="checkOptions"><?php echo JText::_('JBZOO_IMPORT_CHECK_OPTIONS'); ?></label>
                        <?php echo $controls['checkOptions']; ?>
                    </div>

                    <div class="info">
                        <label for="lose"><?php echo JText::_('JBZOO_IMPORT_LOSE'); ?></label>
                        <?php echo $controls['lose']; ?>
                    </div>

                    <ul id="fields-assign">
                        <?php foreach ($info['columns'] as $key => $column) : ?>
                            <li class="assign">
                                <?php
                                foreach ($controls['fields_types'] as $control) {
                                    echo JString::str_ireplace('__name_placeholder__', $key, $control);
                                }
                                ?>

                                <span class="name">
                                <?php echo JText::_('JBZOO_COLUMN'); ?> #<?php echo($key + 1); ?>
                                    <?php echo !empty($column) ? ' - ' . $column : ''; ?>
                            </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <input type="submit" name="send" value="<?php echo JText::_('JBZOO_FORM_IMPORT'); ?>"
                       style="float: right;margin-right: 16px;"/>

                <div class="clr clearfix"></div>

            </fieldset>

        </div>

        <input type="hidden" name="option" value="com_zoo"/>
        <input type="hidden" name="controller" value="jbimport"/>
        <input type="hidden" name="task" value="itemsSteps"/>

    </form>
</div>

<script type="text/javascript">
    (function ($) {

        function showSelects(val) {
            $('.type-select', $form).hide();
            if (val) {
                $('.type-select-' + val, $form).show();
            }
        }

        var prevParams = <?php echo json_encode($prevParams);?>,
            $form = $('#jbzooimport');

        $('#typeid').change(function () {
            showSelects($(this).val())
        });

        if (prevParams && prevParams.previousParams) {

            var prev = prevParams.previousParams;

            $('#appid').val(prev.appid);
            $('#lose').val(prev.lose);
            $('#key').val(prev.key);
            $('#itemKey').val(prev['itemKey']);
            $('#checkOptions').val(prev['checkOptions']);
            $('#typeid').val(prev.typeid).trigger('change');

            if (prev.typeid) {
                var typeid = prev.typeid;
                $('#fields-assign select.type-select-' + prev.typeid).each(function (n, obj) {
                    $(obj).val(prevParams[typeid][n]);
                });
            }

        }

        $form.submit(function () {
            // TODO validate itemKeys
            if (!$('#appid', $form).val()) {
                alert('<?php echo JText::_('JBZOO_IMPORT_NO_APP');?>');
                return false;
            }

            if (!$('#typeid', $form).val()) {
                alert('<?php echo JText::_('JBZOO_IMPORT_NO_TYPE');?>');
                return false;
            }

            return true;
        });

    })(jQuery);
</script>
