<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBTypeHelper
 */
class JBTypeHelper extends AppHelper
{

    /**
     * @param string|array $newOption
     * @param string $elementId
     * @param string $typeId
     * @param int $appId
     * @return bool
     */
    public function checkOption($newOption, $elementId, $typeId, $appId)
    {
        $application = $this->app->table->application->get($appId);
        if ($application) {
            $type = $application->getType($typeId);
        }

        if (!isset($type)) {
            return false;
        }

        $elements      = $type->config->get('elements', array());
        $newOptionSlug = $this->app->string->sluggify($newOption);

        // check is valid element structure
        if (!isset($elements[$elementId]['option']) || !is_array($elements[$elementId]['option'])) {
            return false;
        }

        $found = false;
        foreach ($elements[$elementId]['option'] as $key => $option) {

            if ($option['value'] == $newOptionSlug || $option['name'] == $newOption) {
                $found = true;
                break;
            }
        }

        if (!$found) {
            $elements[$elementId]['option'][] = array(
                'name'  => $newOption,
                'value' => $this->app->string->sluggify($newOption),
            );
            $type->config->set('elements', $elements);

            $type->bindElements($elements);
            $type->save();
            return true;
        }

        return false;
    }

}
