<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBModelRelated
 */
class JBModelRelated extends JBModel
{

    /**
     * Create and return self instance
     * @return JBModelRelated
     */
    public static function model()
    {
        return new self();
    }

    /**
     * Get auto related items
     * @param Item $item
     * @param JSONData $config
     * @param JSONData $params
     * @return array
     */
    public function getRelated(Item $item, $config, $params)
    {
        $this->app->jbdebug->mark('model::getRelated::start');

        $cacheHash = sha1(serialize((array)$params) . '||' . serialize((array)$config) . '||itemid-' . $item->id);
        $cacheKey  = 'related-items/' . $cacheHash;

        if (!($result = $this->app->jbcache->get($cacheHash, $cacheKey))) {

            $searchMethod = (int)$params->get('search-method', 2);

            $data   = $this->_getSearchData($item);
            $rows   = $this->_getFromDatabase($item, $data, $searchMethod, $params);
            $result = $this->_sortByRelevant($rows, $params);

            $this->app->jbcache->set($cacheHash, $result, $cacheKey);

        }

        $this->app->jbdebug->mark('model::getRelated::loadItems');
        $result = $this->getZooItemsByIds(array_keys($result));

        $this->app->jbdebug->mark('model::getRelated::end');

        return $result;
    }

    /**
     * Sort db result by relevant
     * @param Array $rows
     * @param JSONData $params
     * @return array
     */
    protected function _sortByRelevant($rows, $params)
    {
        $resultTmp = array();
        foreach ($rows as $row) {
            $id = $row['id'];
            unset($row['id']);
            $resultTmp[$id] = $row;
        }

        $result = array();
        foreach ($resultTmp as $itemId => $row) {
            $result[$itemId] = array_sum($row);

            if ($result[$itemId] < (int)$params->get('relevant', 5)) {
                unset($result[$itemId]);
            }
        }

        arsort($result);

        return array_slice($result, 0, (int)$params->get('count', 8), true);
    }

    /**
     * Get all item from database
     * @param Item $item
     * @param Array $data
     * @param Int $searchMethod
     * @param Array $params
     * @return array
     */
    protected function _getFromDatabase(Item $item, $data, $searchMethod, $params)
    {
        $where  = array();
        $select = array('tItem.id');

        foreach ($data as $elementId => $elemValues) {

            $elementId = $this->_quote($elementId);

            $elemValues = (array)$elemValues;
            $elemValues = $this->_toCleanArray($elemValues);

            if (is_null($elemValues)) {
                continue;
            }

            if ($searchMethod == 1) {

                $select[] = 'SUM(('
                    . ' tIndex.element_id = ' . $elementId . ' AND '
                    . ' (IF(tIndex.value_string = ' . implode(', 1, 0) + IF(tIndex.value_string = ', $elemValues) . ', 1, 0))'
                    . ')) AS ' . $elementId;

            } else if ($searchMethod == 2) {

                $select[] = 'SUM(('
                    . ' tIndex.element_id = ' . $elementId . ' AND '
                    . ' (IF(tIndex.value_string LIKE "%' . implode('%", 1, 0) + IF(tIndex.value_string LIKE "%', $elemValues) . '%", 1, 0))'
                    . ')) AS ' . $elementId;

            } else if ($searchMethod == 3) {

                $select[] = 'SUM(IF(tIndex.value_string LIKE "%' . implode('%", 1, 0) + IF(tIndex.value_string LIKE "%', $elemValues) . '%", 1, 0))'
                    . ' AS ' . $elementId;
            }

            // collect where data
            $where[] = $elementId;
        }

        $select = $this->_getItemSelect()->clear('select')
            ->select($select)
            ->from(ZOO_TABLE_ITEM . ' AS tItem')
            ->innerJoin(ZOO_TABLE_JBZOO_INDEX . ' AS tIndex ON tIndex.item_id = tItem.id')
            ->where('tItem.id <> ?', $item->id)
            ->where('tItem.type = ?', $item->type)
            ->where('tIndex.element_id IN (' . implode(',', $where) . ')')
            ->group('tItem.id');

        if ((int)$params->get('check_app', 1)) {
            $select->where('tItem.application_id = ?', $item->application_id);
        }

        if ($checkCategory = (int)$params->get('check_category', 1)) {

            if ($checkCategory == 1) {
                $categoryId = $item->getPrimaryCategoryId();
                $select
                    ->leftJoin(ZOO_TABLE_CATEGORY_ITEM . ' AS tCategory ON tCategory.item_id = tItem.id')
                    ->where('tCategory.category_id = ?', $categoryId);
            }

            if ($checkCategory == 2) {
                $categoryIds = $item->getRelatedCategoryIds();
                $select
                    ->innerJoin(ZOO_TABLE_CATEGORY_ITEM . ' AS tCategory ON tCategory.item_id = tItem.id')
                    ->where('tCategory.category_id IN (' . implode(',', $categoryIds) . ')');
            }
        }

        $having = array();
        foreach ($where as $whereRow) {
            $having[] = $whereRow . ' <> 0';
        }

        $select->having('(' . implode(' OR ', $having) . ')');

        $this->_setBigSelects();

        // clean query for optimization
        $db = JFactory::getDbo();
        $db->setQuery((string)$select);
        $rows = $db->loadAssocList();

        return $rows;
    }

    /**
     * Check is value empty
     * @param $value
     * @return bool
     */
    protected function _isEmpty($value)
    {
        return (empty($value) && ($value !== 0 || $value !== "0"));
    }

    /**
     * Convert data to clean array
     * @param $elemValues
     * @return array
     */
    protected function _toCleanArray($elemValues)
    {

        foreach ($elemValues as $key => $elemValue) {

            if (is_array($elemValue)) {

                foreach ($elemValue as $innerKey => $innerValue) {
                    if ($this->_isEmpty($innerValue)) {
                        unset($elemValue[$innerKey]);
                    }
                }

                $elemValues[$key] = $elemValue;

            } else if ($this->_isEmpty($elemValue)) {
                unset($elemValues[$key]);
            }
        }

        $elemValues = $this->_quote($elemValues);

        return (!empty($elemValues) ? $elemValues : null);
    }


    /**
     * Get search data from item
     * @param Item $item
     * @return array
     */
    protected function _getSearchData(Item $item)
    {
        $result = array();

        $elements = $item->getElements();
        foreach ($elements as $element) {
            if ($data = $element->getSearchData()) {
                $result[$element->identifier] = JString::trim($data);
            }
        }

        $itemCategories           = JBModelSearchindex::model()->getRelatedCategoryIds($item->id);
        $result['_itemcategory']  = $itemCategories;
        $result['_itemfrontpage'] = (int)in_array('0', $itemCategories, true);
        $result['_itemname']      = $item->name;
        $result['_itemtag']       = $item->getTags();

        return $result;
    }

}
