<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBModelSearchindex
 */
class JBModelSearchindex extends JBModel
{

    /**
     * Create and return self instance
     * @return JBModelSearchindex
     */
    public static function model()
    {
        return new self();
    }

    /**
     * Check columns in search index table
     * Add new fields if it not exists
     */
    public function checkColumns()
    {
        static $isChecked;

        if (!isset($isChecked)) {

            $this->_dbHelper->query('CREATE TABLE IF NOT EXISTS `' . ZOO_TABLE_JBZOO_INDEX . '` (
                    `id` INT(11) NOT NULL AUTO_INCREMENT,
                    `item_id` INT(11) NOT NULL,
                    `element_id` VARCHAR(50) NOT NULL,
                    `value_number` DOUBLE NULL DEFAULT NULL,
                    `value_datetime` DATETIME NULL DEFAULT NULL,
                    `value_string` VARCHAR(100) NULL DEFAULT NULL COLLATE \'utf8_general_ci\',
                    PRIMARY KEY (`id`),
                    INDEX `element_id_value_number` (`element_id`, `value_number`),
                    INDEX `element_id_value_datetime` (`element_id`, `value_datetime`),
                    INDEX `value_string` (`value_string`),
                    INDEX `item_id` (`item_id`),
                    INDEX `element_id_value_string` (`element_id`, `value_string`)
                )
                COLLATE=\'utf8_general_ci\'
                ENGINE=MyISAM'
            );
        }
        $isChecked = true;
    }

    /**
     * Reindex database
     * @param int $limit
     * @param int $offset
     * @return int
     */
    public function reIndex($limit = 100, $offset = 0)
    {
        $this->app->jbenv->maxPerfomance();

        $total = 0;

        if ($offset == 0) {
            $this->dropTable();
            $this->checkColumns();

            $skuModel = JBModelSku::model();
            $skuModel->dropTable();
            $skuModel->checkColumns();
        }

        $select = $this->_getSelect()
            ->select('tItem.id')
            ->from(ZOO_TABLE_ITEM . ' AS tItem')
            ->limit($limit, $offset);

        $rows = $this->fetchAll($select, true);

        if (empty($rows)) {
            return 0;
        }

        $ids   = $this->_groupBy($rows);
        $items = array();
        foreach ($ids as $id) {
            $items[$id] = $this->app->table->item->get($id);
        }

        $dataPack = array();
        foreach ($items as $key => $item) {
            $dataPack = array_merge($dataPack, $this->updateByItem($item, true));
        }

        $totalLInesAdded = $this->_multiInsertData($dataPack);

        return $totalLInesAdded;
    }

    /**
     * Get total items count
     */
    public function getTotal()
    {
        $select = $this->_getSelect()
            ->select('COUNT(tItem.id) AS count')
            ->from(ZOO_TABLE_ITEM . ' AS tItem');

        $result = $this->fetchRow($select);

        return (int)$result->count;
    }

    /**
     * Get data for database from serach index item
     * @param $row
     * @return array
     */
    public function _getData($row)
    {
        if ($elementType = $this->app->jbentity->getTypeByElementId($row->element_id)) {

            if ($elementType == 'textarea') {
                return array();

            } elseif ($elementType == 'country') {
                $elements   = $this->app->jbentity->getItemTypesData();
                $row->value = $this->_parseCoutries($row->value, $elements[$row->element_id]);
            }
        }

        $multiInsert = array();

        $row->value = JString::trim($row->value);

        // check is number
        $strings = explode("\n", $row->value);
        if (!empty($strings)) {
            foreach ($strings as $string) {

                $string = JString::trim($string);
                if ($string != '') {
                    if (preg_match('#^([0-9\.\,\-]+)#ius', $string, $matches)) {

                        $number = str_replace(',', '.', $matches[1]);
                        if (is_numeric($number)) {
                            $multiInsert[] = array('value_number' => $number);
                        }
                    }

                    $multiInsert[] = array('value_string' => $string);
                }
            }
        }

        // check date
        $times = $this->app->jbdate->convertToStamp($row->value);
        if (!empty($times)) {
            foreach ($times as $time) {
                if (!empty($time)) {
                    $multiInsert[] = array('value_datetime' => $time);
                }
            }
        }

        return $this->_getInsertData($multiInsert, $row);
    }

    /**
     * Update JBZoo index by itemId
     * @param Item $item
     * @param bool $returnDataPack
     * @return int|array
     */
    public function updateByItem(Item $item, $returnDataPack = false)
    {
        $this->removeById($item);
        JBModelSku::model()->updateItemSku($item);

        $rows = array();

        $elements = $item->getElements();
        foreach ($elements as $element) {

            $rows[] = (object)array(
                'value'      => $element->getSearchData(),
                'element_id' => $element->identifier,
                'item_id'    => $item->id,
            );
        }

        $rows = array_merge($rows, $this->_parseStdData($item));

        $dataPack = array();

        foreach ($rows as $row) {
            $dataPack = array_merge($dataPack, $this->_getData($row));
        }

        if ($returnDataPack) {
            return $dataPack;
        }

        return $this->_multiInsertData($dataPack);
    }

    /**
     * Remove item by it Id
     * @param Item $item
     */
    public function removeById($item)
    {
        $this->checkColumns();

        $delete = $this->_getSelect()
            ->delete(ZOO_TABLE_JBZOO_INDEX)
            ->where('item_id = ?', (int)$item->id);

        $this->_dbHelper->query((string)$delete);
    }

    /**
     * Drop JBZoo search index table
     */
    public function dropTable()
    {
        $this->_dbHelper->query('DROP TABLE IF EXISTS `' . ZOO_TABLE_JBZOO_INDEX . '`');
    }

    /**
     * Multi insert query
     * @param array $multiInsert
     * @param stdClass $row
     * @return array
     */
    private function _getInsertData($multiInsert, $row)
    {
        if (!empty($multiInsert)) {
            foreach ($multiInsert as $key => $item) {
                $multiInsert[$key]['item_id']    = $row->item_id;
                $multiInsert[$key]['element_id'] = $row->element_id;
            }
        }

        return $multiInsert;
    }

    /**
     * Multi insert data
     * @param array $rows
     * @return int
     */
    private function _multiInsertData(array $rows)
    {
        $count = 0;
        if (count($rows)) {
            $count = count($rows);

            $groupRows = array();

            foreach ($rows as $row) {
                $keys = array_keys($row);
                sort($keys);
                $groupRows[implode('.', $keys)][] = $row;
            }

            if (!empty($groupRows)) {
                foreach ($groupRows as $group) {
                    $this->_multiInsert($group, ZOO_TABLE_JBZOO_INDEX);
                }
            }
        }

        return $count;
    }

    /**
     * Parse coutries
     * @param $value
     * @param $element
     * @return string
     */
    private function _parseCoutries($value, $element)
    {
        $result = array();

        if (!empty($element['selectable_country'])) {

            foreach ($element['selectable_country'] as $countryISO) {

                $country = $this->app->country->isoToName($countryISO);

                if (strpos($value, $country) !== false) {
                    $result[] = JText::_($country);
                }

            }
        }

        return implode("\n", $result);
    }

    /**
     * Parse Standart item data
     * @param Item $item
     * @return array
     */
    private function _parseStdData($item)
    {
        $itemCategories = $this->getRelatedCategoryIds($item->id);
        $itemTags       = $this->_getRelatedTags($item->id);

        $result = array(
            (object)array('element_id' => '_itemauthor', 'item_id' => $item->id, 'value' => $item->created_by),
            (object)array('element_id' => '_itemcategory', 'item_id' => $item->id, 'value' => implode("\n", $itemCategories)),
            (object)array('element_id' => '_itemcreated', 'item_id' => $item->id, 'value' => $item->created),
            (object)array('element_id' => '_itemfrontpage', 'item_id' => $item->id, 'value' => (int)in_array('0', $itemCategories, true)),
            (object)array('element_id' => '_itemmodified', 'item_id' => $item->id, 'value' => $item->modified),
            (object)array('element_id' => '_itemname', 'item_id' => $item->id, 'value' => $item->name),
            (object)array('element_id' => '_itempublish_down', 'item_id' => $item->id, 'value' => $item->publish_down),
            (object)array('element_id' => '_itempublish_up', 'item_id' => $item->id, 'value' => $item->publish_up),
            (object)array('element_id' => '_itemtag', 'item_id' => $item->id, 'value' => implode("\n", $itemTags)),
        );

        return $result;
    }

    /**
     * Get related category id list
     * @param int $itemId
     * @return array
     */
    public function getRelatedCategoryIds($itemId)
    {
        $select = $this->_getSelect()
            ->select('tCategory.category_id AS category_id')
            ->from(ZOO_TABLE_CATEGORY_ITEM . ' AS tCategory')
            ->where('tCategory.item_id = ?', $itemId);

        $rows = $this->fetchAll($select);

        $result = array();
        foreach ($rows as $row) {
            $result[] = $row->category_id;
        }

        return $result;
    }

    /**
     * Get related tags
     * @param int $itemId
     * @return array
     */
    private function _getRelatedTags($itemId)
    {
        $select = $this->_getSelect()
            ->select('tTags.name AS name')
            ->from(ZOO_TABLE_TAG . ' AS tTags')
            ->where('tTags.item_id = ?', $itemId);

        $rows = $this->fetchAll($select);

        $result = array();
        foreach ($rows as $row) {
            $result[] = $row->name;
        }

        return $result;
    }

}
