<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


?>
<div class="jbzoo">
    <form class="jbzoo-import-fields jbadminform" method="post"
          action="index.php" name="jbzooimport" id="jbzooimport" enctype="multipart/form-data">

        <div class="box-bottom">

            <h2><?php echo JText::_('JBZOO_IMPORT_FIELDS'); ?></h2>


            <fieldset class="items">

                <input type="submit" name="send" value="<?php echo JText::_('JBZOO_FORM_IMPORT'); ?>"
                       style="float: right;margin-right: 16px;"/>

                <div class="clr clearfix"></div>

                <div class="assign-group">

                    <div class="info">
                        <label for="appid"><?php echo JText::_('JBZOO_IMPORT_CHOOSE_APP'); ?></label>
                        <?php echo $controls['apps']; ?>
                    </div>

                    <div class="info">
                        <label for="key"><?php echo JText::_('JBZOO_IMPORT_KEY'); ?></label>
                        <?php echo $controls['key']; ?>
                    </div>

                    <div class="info">
                        <label for="lose"><?php echo JText::_('JBZOO_IMPORT_LOSE'); ?></label>
                        <?php echo $controls['lose']; ?>
                    </div>

                    <ul id="fields-assign">
                        <?php foreach ($info['columns'] as $key => $column) : ?>
                            <li class="assign">
                                <?php echo $controls['fields_types']; ?>
                                <span class="name">
                                <?php echo JText::_('JBZOO_COLUMN'); ?> #<?php echo($key + 1); ?>
                                    <?php echo !empty($column) ? ' - ' . $column : ''; ?>
                            </span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <input type="submit" name="send" value="<?php echo JText::_('JBZOO_FORM_IMPORT'); ?>"
                       style="float: right;margin-right: 16px;"/>

                <div class="clr clearfix"></div>

            </fieldset>

        </div>

        <input type="hidden" name="option" value="com_zoo"/>
        <input type="hidden" name="controller" value="jbimport"/>
        <input type="hidden" name="task" value="categoriesSteps"/>

    </form>
</div>

<script type="text/javascript">
    (function ($) {

        $('.type-select').show(); // template hack

        var prevParams = <?php echo json_encode($prevParams);?>,
            $form = $('#jbzooimport');

        if (prevParams) {

            $('#appid').val(prevParams.appid);
            $('#lose').val(prevParams.lose);
            $('#categoryKey').val(prevParams.itemKey);
            $('#key').val(prevParams.key);

            if (prevParams.assign) {
                $('#fields-assign select.type-select').each(function (n, obj) {
                    $(this).val(prevParams.assign[n]);
                });
            }
        }

        $form.submit(function () {
            // TODO validate categoryKey
            if (!$('#appid', $form).val()) {
                alert('<?php echo JText::_('JBZOO_IMPORT_NO_APP');?>');
                return false;
            }

            return true;
        });

    })(jQuery);
</script>
