<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBFormHelper
 */
class JBFormHelper extends AppHelper
{
    /**
     * Render Joomla form
     * @param $formName
     * @param array $options
     * @param array $data
     * @return null|string
     */
    public function render($formName, $options = array(), $data = array())
    {
        if (!($xmlPath = $this->app->path->path('jbconfig:forms/' . $formName . '.xml'))) {
            return null;
        }

        $form = $this->_createJoomlaForm($formName, $xmlPath, $options);
        $form->bind($data);

        $html   = array();
        $html[] = '<dl>';
        foreach ($form->getFieldsets() as $fieldSet) {

            $fieldSetName = $fieldSet->name;

            $html[] = '<fieldset class="adminform ' . $fieldSetName . '">';

            if ($fieldSet->label) {
                $html[] = '<legend>' . JText::_($fieldSet->label) . '</legend>';
            }

            if ($fieldSet->description) {
                $html[] = '<p>' . JText::_($fieldSet->description) . '</p>';
            }

            foreach ($form->getFieldset($fieldSetName) as $field) {
                $html[] = $this->_renderFieldRow($field);
            }

            $html[] = '</fieldset>';
        }

        $html[] = '</dl>';

        JHtml::_('behavior.tooltip');
        JHtml::_('behavior.formvalidation');

        $options = array_merge(array(
            'action'         => $this->app->jbrouter->admin(array('task' => $formName)),
            'method'         => 'post',
            'class'          => 'jbadminform',
            'accept-charset' => "UTF-8",
            'enctype'        => 'multipart/form-data',
        ), $options);

        $submitLabel = isset($options['submit']) ? $options['submit'] : JText::_('JBZOO_FORM_SUBMIT');

        return '<form ' . $this->app->jbhtml->buildAttrs($options) . ' >'
        . implode(" \n", $html)
        . '<div class="submit-btn"><input type="submit" class="jbbutton" name="send" value="' . $submitLabel . '" /></div>'
        . '</form>'
        . '<div class="clr"></div>';
    }

    /**
     * Create Joomla Form
     * @param $name
     * @param $xmlPath
     * @param array $options
     * @return JForm
     */
    protected function _createJoomlaForm($name, $xmlPath, array $options = array())
    {
        jimport('joomla.form.form');
        $jform = JForm::getInstance($name, $xmlPath, array(
            'control' => 'jbzooform'
        ));

        return $jform;
    }

    /**
     * Render one form row
     * @param $field
     * @return string
     */
    protected function _renderFieldRow($field)
    {
        $className = strtolower(get_class($field));

        $html = array();

        if ($field->hidden) {
            $html[] = $field->input;

        } else {
            $html[] = '<dt class="' . $className . '-label"> ' . $field->label . ' </dt>';
            $html[] = '<dd class="' . $className . '-field"> ' . $field->input . '
                <div class="clr"></div>
            </dd>';
        }

        return implode(" \n", $html);
    }

}
