<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBModelAutocomplete
 */
Class JBModelAutocomplete extends JBModel
{

    /**
     * Create and return self instance
     * @return JBModelAutocomplete
     */
    public static function model()
    {
        return new self();
    }

    /**
     * Autocomplete query
     * @param string $query
     * @param string $element
     * @param null|string $type
     * @param null|int $applicationId
     * @param int $limit
     * @return JObject
     */
    public function field($query, $element, $type = null, $applicationId = null, $limit = 10)
    {
        if (empty($query)) {
            return array();
        }

        $select = $this->_getSelect()
            ->select('tIndex.value_string as value')
            ->from(ZOO_TABLE_JBZOO_INDEX . ' AS tIndex')
            ->where('tIndex.element_id = ?', $element)
            ->where($this->_buildLikeBySpaces($query, 'tIndex.value_string'))
            ->where('tIndex.value_string <> ?', JBModelElementJBImage::IMAGE_EXISTS)
            ->where('tIndex.value_string <> ?', JBModelElementJBImage::IMAGE_NO_EXISTS)
            ->group('tIndex.value_string')
            ->order('tIndex.value_string')
            ->limit($limit);

        return $this->fetchAll($select);
    }

    /**
     * Autocomplete by item name
     * @param string $query
     * @param null|string $type
     * @param null|string $applicationId
     * @param int $limit
     * @return null|array
     */
    public function name($query, $type = null, $applicationId = null, $limit = 10)
    {
        if (empty($query)) {
            return array();
        }

        $select = $this->_getItemSelect($type, $applicationId)
            ->clear('select')
            ->select(array('tItem.name AS value', 'tItem.id'))
            ->where($this->_buildLikeBySpaces($query, 'tItem.name'))
            ->group('tItem.name')
            ->order('tItem.name')
            ->limit($limit);

        return $this->fetchAll($select);
    }

    /**
     * Autocomplete by item tags
     * @param string $query
     * @param null|string $type
     * @param null|string $applicationId
     * @param int $limit
     * @return null|array
     */
    public function tag($query, $type = null, $applicationId = null, $limit = 10)
    {
        if (empty($query)) {
            return array();
        }

        $select = $this->_getItemSelect($type, $applicationId)
            ->clear('select')
            ->select(array('tTag.name AS value'))
            ->innerJoin(ZOO_TABLE_TAG . ' AS tTag ON tTag.item_id = tItem.id')
            ->where($this->_buildLikeBySpaces($query, 'tTag.name'))
            ->group('tTag.name')
            ->order('tTag.name ASC')
            ->limit($limit);

        return $this->fetchAll($select);
    }

    /**
     * Autocomplete by authors
     * @param string $query
     * @param null|string $type
     * @param null|string $applicationId
     * @param int $limit
     * @return null|array
     */
    public function author($query, $type = null, $applicationId = null, $limit = 10)
    {
        if (empty($query)) {
            return array();
        }

        $select = $this->_getSelect()
            ->select(array('tUsers.name AS value'))
            ->from(ZOO_TABLE_ITEM . ' AS tItem')
            ->innerJoin('#__users AS tUsers ON tUsers.id = tItem.created_by')
            ->where('tItem.application_id = ?', (int)$applicationId)
            ->where('tItem.type = ?', $type)
            ->where($this->_buildLikeBySpaces($query, 'tUsers.name'))
            ->group('tUsers.name')
            ->order('tUsers.name ASC')
            ->limit($limit);

        return $this->fetchAll($select);
    }

    /**
     * Autocomplete query for item SKU
     * @param string $query
     * @param string $element
     * @param null|string $type
     * @param null|int $applicationId
     * @param int $limit
     * @return JObject
     */
    public function sku($query, $element, $type = null, $applicationId = null, $limit = 10)
    {
        if (empty($query)) {
            return array();
        }

        $select = $this->_getSelect()
            ->select(array('tSku.sku AS value'))
            ->from(ZOO_TABLE_JBZOO_SKU . ' AS tSku')
            ->innerJoin(ZOO_TABLE_ITEM . ' AS tItem ON tItem.id = tSku.item_id')
            ->where('tItem.application_id = ?', (int)$applicationId)
            ->where('tItem.type = ?', $type)
            ->where($this->_buildLikeBySpaces($query, 'tSku.sku'))
            ->group('tSku.sku')
            ->order('tSku.sku ASC')
            ->limit($limit);

        return $this->fetchAll($select);
    }
}
