<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


$total = JBModelSearchindex::model()->getTotal();
$this->app->jbassets->progressBar();

if (0 == $total) {
    echo '<strong style="color:#a00;">' . JText::_('JBZOO_CHECKDB_NOITEMS') . '</strong>';
    return;
}

?>

<div class="jbzoo">

    <h2><?php echo JText::_('JBZOO_REINDEX_TITLE'); ?></h2>

    <p style="margin-left:0;color:#a00;font-weight:bold;">
        <?php echo JText::_('JBZOO_REINDEX_DESCRIPTION'); ?>
    </p>

    <div class="jsProgressBar progress jbadminform"></div>

    <div class="statistic">
        <strong><?php echo JText::_('JBZOO_REINDEX_STATISTIC'); ?>: </strong>
        <ul>
            <li><strong><?php echo JText::_('JBZOO_REINDEX_PROGRESS'); ?>:</strong> <span
                    class="js-progress">0</span>%
            </li>

            <li><strong><?php echo JText::_('JBZOO_REINDEX_STEP_CURRENT'); ?>:</strong> <span
                    class="js-step">0</span></li>

            <li><strong><?php echo JText::_('JBZOO_REINDEX_INDEXED'); ?>:</strong> <span
                    class="js-current">0</span></li>

            <li><strong><?php echo JText::_('JBZOO_REINDEX_TOTAL'); ?>:</strong> <span
                    class="js-total"><?php echo $total; ?></span></li>

            <li><strong><?php echo JText::_('JBZOO_REINDEX_STEP_SIZE'); ?>:</strong> <span
                    class="js-stepsize"><?php echo self::INDEX_STEP; ?></span></li>

            <!--<li><strong><?php echo JText::_('JBZOO_REINDEX_LINES'); ?>:</strong> <span
                    class="js-totallines">0</span></li>-->
        </ul>
        <ul>
            <li><strong><?php echo JText::_('JBZOO_REINDEX_TIME_PASSED'); ?>:</strong> <span
                    class="js-timepassed">00:00</span></li>

            <li><strong><?php echo JText::_('JBZOO_REINDEX_TIME_REMAINING'); ?>:</strong> <span
                    class="js-timeremaining">00:00</span></li>
        </ul>
    </div>
</div>

<script type="text/javascript">
    jQuery(function ($) {

        var totalLines = 0;

        $('.jsProgressBar').JBZooProgressBar({
            'text_start_confirm': "<?php echo JText::_('JBZOO_PROGRESSBAR_START_CONFIRM');?>",
            'text_stop_confirm' : "<?php echo JText::_('JBZOO_PROGRESSBAR_STOP_CONFIRM');?>",
            'text_complete'     : "<?php echo JText::_('JBZOO_PROGRESSBAR_COMPLETE');?>",
            'text_start'        : "<?php echo JText::_('JBZOO_PROGRESSBAR_START');?>",
            'text_stop'         : "<?php echo JText::_('JBZOO_PROGRESSBAR_STOP');?>",
            'text_ready'        : "<?php echo JText::_('JBZOO_PROGRESSBAR_READY');?>",
            'url'               : "<?php echo $this->app->jbrouter->admin(array('task' => 'checkdbajax'));?>",
            'onRequest'         : function (data) {
                totalLines = totalLines + data.lines;
                $('.js-totallines').text(totalLines);
                $.each(data, function (key, data) {
                    $('.js-' + key).text(data);
                });
            },
            'onStop'            : function () {
                $('.js-timeremaining').text('00:00');
            },
            'onTimer'           : function (data) {
                $('.js-timepassed').text(data.passed);
                $('.js-timeremaining').text(data.remaining);
            }
        });
    });
</script>
