<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBEventItem
 */
class JBEventItem extends JBEvent
{

    /**
     * On item init
     * @param AppEvent $event
     */
    public static function init($event)
    {
    }

    /**
     * On item saved event
     * @static
     * @param $event AppEvent
     * @return null
     */
    public static function saved($event)
    {
        $item = $event->getSubject();

        JBModelSku::model()->updateItemSku($item);

        // hack for JBZoo import optimization
        if ($item->getParams()->get('jbzoo.no_index', 0) == 1) {
            return null;
        }

        JBModelSearchindex::model()->updateByItem($item);
    }

    /**
     * On item deleted event
     * @static
     * @param $event AppEvent
     */
    public static function deleted($event)
    {
        $item = $event->getSubject();

        JBModelSearchindex::model()->removeById($item);
        JBModelSku::model()->removeByItem($item);

        $jbimageElements = $item->getElements();

        foreach ($jbimageElements as $element) {
            if (method_exists($element, 'triggerItemDeleted')) {
                $element->triggerItemDeleted();
            }
        }
    }

    /**
     * On item status changed
     * @param AppEvent $event
     */
    public static function stateChanged($event)
    {
    }

    /**
     * On item before display
     * @param AppEvent $event
     */
    public static function beforeDisplay($event)
    {
    }

    /**
     * On item after display
     * @param AppEvent $event
     */
    public static function afterDisplay($event)
    {
    }
}