<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBModelSku
 */
class JBModelSku extends JBModel
{

    /**
     * Create and return self instance
     * @return JBModelSku
     */
    public static function model()
    {
        return new self();
    }

    /**
     * Check columns in SKU table
     * Add new fields if it not exists
     */
    public function checkColumns()
    {
        static $isChecked;

        if (!isset($isChecked)) {
            $this->_dbHelper->query('CREATE TABLE IF NOT EXISTS `' . ZOO_TABLE_JBZOO_SKU . '` (
                    `id` INT(11) NOT NULL AUTO_INCREMENT,
                    `item_id` INT(11) NOT NULL,
                    `element_id` VARCHAR(50) NOT NULL,
                    `sku` VARCHAR(100) NOT NULL,
                    `type` INT(11) NOT NULL,
                    `is_new` TINYINT(4) NOT NULL DEFAULT \'0\',
                    `is_sale` TINYINT(4) NOT NULL DEFAULT \'0\',
                    `price` FLOAT NOT NULL,
                    `total` FLOAT NOT NULL,
                    `currency` VARCHAR(20) NOT NULL,
                    `balance` INT(11) NOT NULL DEFAULT \'0\',
                    `hash` VARCHAR(150) NULL DEFAULT NULL,
                    `params` TEXT NULL,
                    PRIMARY KEY (`id`),
                    INDEX `hash` (`hash`),
                    INDEX `item_id` (`item_id`),
                    INDEX `type` (`type`),
                    INDEX `element_id` (`element_id`),
                    INDEX `price` (`price`),
                    INDEX `total` (`total`),
                    INDEX `sku` (`sku`),
                    INDEX `is_new` (`is_new`),
                    INDEX `is_sale` (`is_sale`)
                )
                COLLATE=\'utf8_general_ci\''
            );
        }
        $isChecked = true;
    }

    /**
     * Drop JBZoo SKU table
     */
    public function dropTable()
    {
        $this->_dbHelper->query('DROP TABLE IF EXISTS `' . ZOO_TABLE_JBZOO_SKU . '`');
    }

    /**
     * Update SKU by item
     * @param Item $item
     * @return bool
     */
    public function updateItemSku(Item $item)
    {
        if ($item) {
            $this->checkColumns();
            $this->removeByItem($item);

            $priceElements = $item->getElementsByType('jbpriceadvance');

            if (!empty($priceElements)) {
                foreach ($priceElements as $element) {
                    $this->_indexPrice($element->getIndexData());
                }
                return true;
            }
        }

        return false;
    }

    /**
     * Save to index table
     * @param array $data
     * @return bool
     */
    public function _indexPrice(array $data)
    {
        if (!empty($data)) {
            foreach ($data as $values) {
                $values['params'] = (string)$this->app->data->create($values['params']);
                $this->_insert($values, ZOO_TABLE_JBZOO_SKU);
            }
            return true;
        }
        return false;
    }

    /**
     * Remove rows by item
     */
    public function removeByItem(Item $item)
    {
        $select = $this->_getSelect()
            ->delete(ZOO_TABLE_JBZOO_SKU)
            ->where('item_id = ?', $item->id);

        $this->sqlQuery($select);
    }

    /**
     * Get item by sku
     */
    public function getItemIdBySku($sku)
    {
        $select = $this->_getSelect()
            ->select('item_id')
            ->from(ZOO_TABLE_JBZOO_SKU)
            ->where('sku = ?', $sku)
            ->limit(1);

        if ($row = $this->fetchRow($select)) {
            $row = $this->_groupBy($row, 'item_id');
            reset($row);
            return current($row);
        }

        return null;
    }
}