<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Vitaliy Yanovskiy <joejoker@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class ElementJBQuickView
 */
class ElementJBQuickView extends Element
{
    /**
     * Check, has value
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        return true;
    }

    /**
     * Render element
     * @param array $params
     * @return null|string
     */
    public function render($params = array())
    {
        $params    = $this->app->data->create($params);
        $popupName = $params->get('popup', 'mootools');
        $class     = 'jbquickview-modal-window';

        if (!empty($this->_item)) {
            return $this->_getLink($params, $popupName, $class);
        }

        return null;
    }

    /**
     * @param $params
     * @param $popupName
     * @param $class
     * @return string
     */
    protected function _getLink($params, $popupName, $class)
    {
        $buttonText  = $params->get('button_text');
        $popupWidth  = (int)$params->get('popup_width', 600) ? $params->get('popup_width', 600) : 600;
        $popupHeight = (int)$params->get('popup_height', 400) ? $params->get('popup_height', 400) : 400;
        $scroll      = (int)$params->get('scroll_enable', 0) ? 'yes' : 'no';
        $autoSize    = (int)$params->get('auto_size_enable', 0) ? 'true' : 'false';

        $layout    = $params->get('layout') ? $params->get('layout') : 'quickview';
        $paramLink = $this->_getParamsLink($layout);

        if (empty($buttonText)) {
            $buttonText = JText::_('JBZOO_QUICKVIEW');
        }

        if ($popupName == 'mootools') {

            $this->app->jbassets->behaviorModal($class);

            return '<!--noindex--><a href="' . $paramLink . '" title="' . $buttonText . ': ' . $this->_item->name .
            '" rel="{handler: \'iframe\', size: {x: ' . $popupWidth . ', y: ' . $popupHeight . '}}" class="' .
            $class . '" ><span class="quickview">' . $buttonText . '</span></a><!--/noindex-->';

        } else {

            $this->app->jbassets->fancybox();

            return '<!--noindex--><a href="' . $paramLink . '" title="' . $this->_item->name .
            '" rel="nofollow" class="' . $class . '" ><span class="quickview">' . $buttonText . '</span></a><!--/noindex-->
                        <script type="text/javascript">
                            jQuery(function ($) {
                                $("a.' . $class . '").fancybox({
                                    type        : "iframe",
                                    fitToView	: true,
                                    width		: "' . $popupWidth . '",
                                    height		: "' . $popupHeight . '",
                                    autoSize	: ' . $autoSize . ',
                                    iframe      : {
                                        scrolling : "' . $scroll . '",
                                        preload   : true
                                    },
                                    closeClick	: false,
                                    title       : null
                                });
                            });
                        </script>';
        }
    }

    /**
     * Get url with param
     * @param string $layout
     * @return string
     */
    protected function _getParamsLink($layout = 'quickview')
    {
        $itemLink = $this->app->route->item($this->_item);

        if (strripos($itemLink, '?')) {
            $paramLink = '&amp;tmpl=component&amp;jbquickview=' . $layout;
        } else {
            $paramLink = '?tmpl=component&amp;jbquickview=' . $layout;
        }

        return JRoute::_($itemLink . $paramLink);
    }

    /**
     * Edit action
     * @return string
     */
    public function edit()
    {
        return false;
    }

}
