<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBToolsJBuniversalController
 * JBZoo tools controller for back-end
 */
class JBToolsJBuniversalController extends AppController
{

    const INDEX_STEP = 25;

    protected $_viewsPath = '';

    /**
     * Constructor
     * @param array $default
     */
    public function __construct($default = array())
    {
        parent::__construct($default);

        $this->app->jbrequest->set('tmpl', 'component');

        $this->baseurl    = $this->app->link(array('controller' => $this->controller), false);
        $this->_viewsPath = $this->app->path->path('jbviews:');
    }

    /**
     * JBZoo admin menu
     */
    public function menu()
    {
        $this->app->jbassets->setAppCSS();
        $this->app->jbassets->setAppJS();
        $this->app->document->addStylesheet("root:administrator/templates/system/css/system.css");

        include $this->_viewsPath . '/menu.tpl.php';
    }

    /**
     * JBZoo admin menu
     */
    public function createReport()
    {
        try {
            ob_start();
            include $this->_viewsPath . '/create-report.tpl.php';
            $content = ob_get_contents();
            $content .= '<!--' . $this->app->zoo->getApplication()->getHash($content) . '-->';
            ob_end_clean();

            //jexit($content); // debug only

            $tmpPath = $this->app->path->path("tmp:") . '/jbzoo-system-report-' . time() . '.html';
            $tmpArch = $this->app->path->path("tmp:") . '/jbzoo-system-report-' . time() . '.zip';

            if (JFile::exists($tmpPath)) {
                JFile::delete($tmpPath);
            }

            if (JFile::exists($tmpArch)) {
                JFile::delete($tmpArch);
            }

            JFile::write($tmpPath, $content);

            $zip = $this->app->archive->open($tmpArch, 'zip');
            $zip->create(array($tmpPath), PCLZIP_OPT_REMOVE_ALL_PATH);

            if (is_readable($tmpArch) && JFile::exists($tmpArch)) {
                $this->app->filesystem->output($tmpArch);
                JFile::delete($tmpPath);
                JFile::delete($tmpArch);
                jexit();
            } else {
                throw new AppException(JText::sprintf('Unable to create file %s', $tmpArch));
            }

        } catch (AppException $e) {
            // raise error on exception
            $this->app->error->raiseNotice(0, JText::_('Error create report') . ' (' . $e . ')');
            $this->setRedirect($this->app->link(array()));

            return;
        }
    }

    /**
     * Check files
     */
    public function checkfilesReport()
    {
        try {
            $results = $this->app->jbcheckfiles->check();
            include($this->_viewsPath . '/checkfiles.tpl.php');
            jexit();

        } catch (JBCheckFilterException $e) {

            $this->app->error->raiseNotice(0, $e);
        }
    }

    /**
     * Index DB by ajax call
     */
    public function checkDbAjax()
    {
        $limit  = self::INDEX_STEP;
        $page   = (int)$this->app->jbrequest->get('page', 0);
        $offset = $limit * $page;

        $modelIndex = JBModelSearchindex::model();

        $lines = $modelIndex->reIndex($limit, $offset);
        $total = $modelIndex->getTotal();

        $current = $limit * ($page + 1);
        if ($current > $total) {
            $current = $total;
        }

        $progress = round($current * 100 / $total, 2);

        $this->app->jbajax->send(array(
            'progress' => $progress,
            'current'  => $current,
            'total'    => $total,
            'lines'    => $lines,
            'step'     => $page + 1,
            'stepsize' => $limit,
        ));
    }

    /**
     * Show licence form
     */
    public function licence()
    {
        $this->app->jbnotify->notice(JText::_('JBZOO_LICENCE_NOVALID'));
        $managerPage = $this->app->jbrouter->admin(array('controller' => 'manager', 'task' => 'info', 'group' => 'jbuniversal'));

        $html   = array();
        $html[] = '<div style="width: 600px;margin: 60px auto 0;">';
        $html[] = $this->app->jbform->render('licence',
            array('action' => $this->app->jbrouter->admin(array('task' => 'saveLicence'))),
            array(
                'JBZOO_USERNAME' => defined('JBZOO_USERNAME') ? JBZOO_USERNAME : '',
                'redirect'       => base64_encode($this->app->jbrouter->admin(array('controller' => 'item'))),
            )
        );

        $html[] = '<div style="margin-top: 12px;font-size:14px;">Go to <a style="text-decoration:underline;" href="' . $managerPage . '">JBZoo App Manager</a></div>';

        $html[] = '</div>';

        echo implode("\n ", $html);
    }

    /**
     * Save licence data
     */
    public function saveLicence()
    {
        $app     = $this->app->zoo->getApplication();
        $licData = $app->getLicenceData($_POST['jbzooform']);
        $host    = $app->getDomain(true);

        $domainPath = $this->app->path->path('jbapp:config') . '/licence.' . $host . '.php';

        $this->app->jbconfig->saveToFile($licData, $domainPath);

        $this->app->jbcache->clear('data-' . $host);
        if (JFile::exists(JPATH_CACHE . '/jbzoo/data-' . $host)) {
            JFile::delete(JPATH_CACHE . '/jbzoo/data-' . $host);
        }

        $redirectUrl = $this->app->jbrouter->admin(array('task' => 'menu', 'tmpl' => 'component'));
        if (!empty($_POST['jbzooform']['redirect'])) {
            $redirectUrl = base64_decode($_POST['jbzooform']['redirect']);
        }

        $this->setRedirect($redirectUrl, JText::_('JBZOO_LICENCE_SAVED'));
    }

    /**
     * Save JBZoo Config file
     */
    public function saveConfig()
    {
        $configPath = $this->app->path->path('jbapp:config') . '/config.php';
        $this->app->jbconfig->saveToFile($_POST['jbzooform'], $configPath);

        $this->setRedirect($this->app->jbrouter->admin(array('task' => 'menu')), JText::_('JBZOO_CONFIG_SAVED'));
    }

    /**
     * Show payment links
     */
    public function paymentLinks()
    {
        $appId = (int)$this->app->jbrequest->get('app_id');
        $app   = $this->app->table->application->get($appId);

        $resultUrl  = $this->app->jbrouter->payment($appId, 'callback');
        $successUrl = $this->app->jbrouter->payment($appId, 'success');
        $failUrl    = $this->app->jbrouter->payment($appId, 'fail');

        include $this->_viewsPath . '/payment-links.tpl.php';
    }

}

/**
 * Class ExceptionJBToolsJBuniversalController
 */
class ExceptionJBToolsJBuniversalController extends AppException
{

}
