<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


$this->app->jbassets->progressBar();
?>

<div class="jbzoo">

    <h2><?php echo JText::_('JBZOO_IMPORT_STEPS_TITLE'); ?></h2>

    <p style="margin-left:0;color:#a00;font-weight:bold;">
        <?php echo JText::_('JBZOO_IMPORT_STEPS_DESCRIPTION'); ?>
    </p>

    <div class="jsProgressBar progress jbadminform"></div>

    <div class="statistic">
        <strong><?php echo JText::_('JBZOO_IMPORT_STEPS_STATISTIC'); ?>: </strong>
        <ul>
            <li><strong><?php echo JText::_('JBZOO_IMPORT_STEPS_TIME_PASSED'); ?>:</strong> <span
                    class="js-timepassed">00:00</span></li>

            <li><strong><?php echo JText::_('JBZOO_IMPORT_STEPS_REMAINING'); ?>:</strong> <span
                    class="js-timeremaining">00:00</span></li>
        </ul>
    </div>
</div>

<script type="text/javascript">
    jQuery(function ($) {

        var totalLines = 0,
            ajax = "<?php echo $this->app->jbrouter->admin(array(
                'controller' => 'jbimport',
                'task' => 'ajax',
                'import-type' => 'items'
                ));?>",
            postAjax = "<?php echo $this->app->jbrouter->admin(array(
                'controller' => 'jbimport',
                'task' => 'postAjax',
                'import-type' => 'items'
                ));?>";

        $('.jsProgressBar').JBZooProgressBar({
            'text_start_confirm': "<?php echo JText::_('JBZOO_PROGRESSBAR_START_CONFIRM');?>",
            'text_stop_confirm' : "<?php echo JText::_('JBZOO_PROGRESSBAR_STOP_CONFIRM');?>",
            'text_complete'     : "<?php echo JText::_('JBZOO_PROGRESSBAR_COMPLETE');?>",
            'text_start'        : "<?php echo JText::_('JBZOO_PROGRESSBAR_START');?>",
            'text_stop'         : "<?php echo JText::_('JBZOO_PROGRESSBAR_STOP');?>",
            'text_ready'        : "<?php echo JText::_('JBZOO_PROGRESSBAR_READY');?>",
            'text_wait'         : "<?php echo JText::_('JBZOO_PROGRESSBAR_WAIT_CLEAN');?>",
            'url'               : ajax,
            'autoStart'         : true,
            'onRequest'         : function (data) {
                $.each(data, function (key, data) {
                    $('.js-' + key).text(data);
                });
            },
            'onStop'            : function () {
                $('.js-timeremaining').text('00:00');
                $('.jsStart, .jsStop').hide();
            },
            'onFinal'           : function (callback) {
                $('.jsLoader').show();
                $.get(postAjax, {
                    'nocache': (new Date()).getMilliseconds()
                }, function () {
                    callback();
                    $('.jsLoader').hide();
                });
            },
            'onTimer'           : function (data) {
                $('.js-timepassed').text(data.passed);
                $('.js-timeremaining').text(data.remaining);
            }
        });
    });
</script>
