<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCSVItemUserJBSelectCascade
 */
class JBCSVItemUserJBSelectCascade extends JBCSVItem
{
    /**
     * @return string|void
     */
    public function toCSV()
    {
        $result = array();

        if (!empty($this->_value)) {
            foreach ($this->_value as $self) {
                $result[] = implode(JBCSVItem::SEP_CELL, $self);
            }
        }

        return $result;
    }

    /**
     * @param $value
     * @param null $position
     * @return Item
     */
    public function fromCSV($value, $position = null)
    {
        $valuesTmp = $this->_getArray($value, JBCSVItem::SEP_CELL);

        $values = array();
        foreach ($valuesTmp as $key => $value) {
            $values['list-' . $key] = $value;
        }

        $data = ($position == 1) ? array() : $this->_element->data();

        $data[] = $values;
        $this->_element->bindData($data);

        return $this->_item;
    }

}
