<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBOrderHelper
 */
class JBOrderHelper extends AppHelper
{

    /**
     * Order list
     * @var array
     */
    private $_orderings = array(
        'priority'      => 'priority ASC',
        'rpriority'     => 'priority DESC',
        'id'            => 'id ASC',
        'rid'           => 'id DESC',
        'alpha'         => 'name ASC',
        'ralpha'        => 'name DESC',
        'alias'         => 'alias ASC',
        'ralias'        => 'alias DESC',
        'hits'          => 'hits ASC',
        'rhits'         => 'hits DESC',
        'date'          => 'created ASC',
        'rdate'         => 'created DESC',
        'mdate'         => 'modified ASC',
        'rmdate'        => 'modified DESC',
        'publish_up'    => 'publish_up ASC',
        'rpublish_up'   => 'publish_up DESC',
        'publish_down'  => 'publish_down ASC',
        'rpublish_down' => 'publish_down DESC',
        'author'        => 'author ASC',
        'rauthor'       => 'author DESC',
        'random'        => 'RAND()',
    );

    /**
     * Order list
     * @var array
     */
    private $_lightOrderings = array(
        'priority'  => 'priority ASC',
        'rpriority' => 'priority DESC',
        'alpha'     => 'name ASC',
        'ralpha'    => 'name DESC',
        'hits'      => 'hits ASC',
        'date'      => 'created ASC',
        'rdate'     => 'created DESC',
        'mdate'     => 'modified ASC',
        'random'    => 'RAND()',
    );

    /**
     * Get order
     * @param string $order
     * @param null|string $context
     * @return string
     */
    function get($order, $context = null)
    {
        $order = isset($this->_orderings[$order]) ? $this->_orderings[$order] : $this->_orderings['rpriority'];

        if ($context && $order != 'RAND()') {
            $order = $context . '.' . $order;
        }

        return $order;
    }

    /**
     * Get order list
     * @return array
     */
    public function getOrderings()
    {
        return $this->_orderings;
    }

    /**
     * Get light ordger list
     */
    public function getLightOrderings()
    {
        return $this->_lightOrderings;
    }

    /**
     * Get order list
     * @param bool $showReverse
     * @return array
     */
    function getList($showReverse = true)
    {
        $result = array();
        foreach ($this->_orderings as $key => $order) {

            if (!$showReverse && $key != 'random' && $key[0] == 'r') {
                continue;
            }

            $result[$key] = JText::_('JBZOO_ORDER_' . trim(preg_replace('#[^a-z]#ius', '_', $order), '_'));
        }

        return $result;
    }

}