<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBToolbarHelper
 */
class JBToolbarHelper extends AppHelper
{

    /**
     * Show toolbar buttons
     */
    public function toolbar()
    {
        if ($this->app->jbrequest->is('controller', 'manager')) {
            $this->_popup('jbzooadmin', 'JBZOO_BUTTON_MENU', array('task' => 'menu'), 950, 600);
            $this->_popup('jbzooimport', 'JBZOO_BUTTON_IMPORT_EXPORT', array('task' => 'index', 'controller' => 'jbimport'), 750, 675);
        }

        $this->_customLink('jbzoosupport', 'JBZOO_BUTTON_SUPPORT', 'http://forum.jbzoo.com');
        $this->_separator();
    }

    /**
     * Show button for popup window
     * @param string $icon
     * @param string $name
     * @param array $urlParams
     * @param int $width
     * @param int $height
     * @return string
     */
    protected function _popup($icon, $name, array $urlParams, $width = 600, $height = 450)
    {
        $urlParams = array_merge(array(
            'option'     => 'com_zoo',
            'tmpl'       => 'component',
            'controller' => 'jbtools',
        ), $urlParams);

        $link = JRoute::_(JURI::root() . 'administrator/index.php?' . http_build_query($urlParams), true, -1);

        return JToolBar::getInstance('toolbar')->appendButton('Popup', $icon, $name, $link, $width, $height);
    }

    /**
     * Show link-button
     * @param string $icon
     * @param string $name
     * @param array $urlParams
     * @return string
     */
    protected function _link($icon, $name, $urlParams)
    {
        $urlParams = array_merge(array(
            'option' => 'com_zoo',
            'tmpl'   => 'component'
        ), $urlParams);

        $link = JRoute::_(JURI::root() . 'administrator/index.php?' . http_build_query($urlParams), true, -1);

        return JToolBar::getInstance('toolbar')->appendButton('Link', $icon, $name, $link);
    }

    /**
     * Show custom link-button
     * @param string $icon
     * @param string $name
     * @param string $link
     * @return string
     */
    protected function _customLink($icon, $name, $link)
    {
        return JToolBar::getInstance('toolbar')->appendButton('Link', $icon, $name, $link);
    }

    /**
     * Add seporator
     * @return string
     */
    protected function _separator()
    {
        JToolBar::getInstance('toolbar')->appendButton('Separator', 'spacer', '90');
    }
}
