<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

App::getInstance('zoo')->jbassets->uikit();
$align = $this->app->jbitem->getMediaAlign($item, $layout);
$tabsId = uniqid('jbzoo-tabs-');

echo $this->renderPosition('title', array('style' => 'jbtitle' , 'class' => 'uk-article-title'));
echo $this->renderPosition('subtitle', array('style' => 'jbsubtitle' , 'class' => 'uk-article-lead'));
echo $this->renderPosition('likes', array('style' => 'jbblock', 'class' => 'align-left'));
echo $this->renderPosition('rating', array('style' => 'jbblock', 'class' => 'align-left'));
?>

<div class="clear clr"></div>

<div class="item-body">

    <?php if ($this->checkPosition('image')) : ?>
        <div class="item-image align-<?php echo $align; ?>"><?php echo $this->renderPosition('image'); ?></div>
    <?php endif; ?>

    <?php if ($this->checkPosition('anons')) : ?>
        <div class="item-anons"><?php echo $this->renderPosition('anons'); ?></div>
    <?php endif; ?>

    <?php if ($this->checkPosition('meta')) : ?>
        <hr/>
        <div class="item-meta">
            <?php echo $this->renderPosition('meta', array('style' => 'jbblock', 'labelTag' => 'strong', 'tag' => 'p')); ?>
        </div>
    <?php endif; ?>
    <div class="clear clr"></div>
</div>

<?php if ($this->checkPosition('social')) : ?>
    <?php echo $this->renderPosition('social', array('style' => 'jbblock')); ?>
<?php endif; ?>

<div class="clear clr"></div>
<hr/>
<?php if ($this->checkPosition('tab-text')
    || $this->checkPosition('tab-gallery')
    || $this->checkPosition('tab-properties')
    || $this->checkPosition('tab-reviews')
    || $this->checkPosition('tab-comments')
) :

    $positionParams = array(
        'style'    => 'jbblock',
        'tag'      => 'div',
        'labelTag' => 'h3',
        'clear'    => true
    );

    ?>

    <div id="<?php echo $tabsId; ?>">
        <ul class="uk-tab" data-uk-tab="{connect:'#tab-content'}">
            <?php if ($this->checkPosition('tab-text')) : ?>
                <li>
                    <a href="#tab-text"><?php echo JText::_('JBZOO_ITEM_TAB_DESCRIPTION'); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($this->checkPosition('tab-properties')) : ?>
                <li>
                    <a href="#tab-properties"><?php echo JText::_('JBZOO_ITEM_TAB_PROPS'); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($this->checkPosition('tab-gallery')) : ?>
                <li>
                    <a href="#tab-gallery"><?php echo JText::_('JBZOO_ITEM_TAB_GALLERY'); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($this->checkPosition('tab-reviews')) : ?>
                <li>
                    <a href="#tab-reviews"><?php echo JText::_('JBZOO_ITEM_TAB_REVIEWS'); ?></a>
                </li>
            <?php endif; ?>

            <?php if ($this->checkPosition('tab-comments')) : ?>
                <li>
                    <a href="#tab-comments"><?php echo JText::_('JBZOO_ITEM_TAB_COMMENTS'); ?>
                        (<?php echo $item->getCommentsCount(); ?>)</a>
                </li>
            <?php endif; ?>
        </ul>

	    <ul id="tab-content" class="uk-switcher uk-margin">

		    <?php if ($this->checkPosition('tab-text')) : ?>
			    <li>
				    <div id="tab-text"><?php echo $this->renderPosition('tab-text', $positionParams); ?></div>
			    </li>
		    <?php endif; ?>

		    <?php if ($this->checkPosition('tab-properties')) : ?>
			    <li>
				    <div id="tab-properties">
					    <table class="uk-table uk-table-hover uk-table-striped">
						    <?php echo $this->renderPosition('tab-properties', array('style' => 'jbtable')); ?>
					    </table>
				    </div>
			    </li>
		    <?php endif; ?>

		    <?php if ($this->checkPosition('tab-gallery')) : ?>
			    <li>
				    <div id="tab-gallery"><?php echo $this->renderPosition('tab-gallery', $positionParams); ?></div>
			    </li>
		    <?php endif; ?>

		    <?php if ($this->checkPosition('tab-reviews')) : ?>
			    <li>
				    <div id="tab-reviews"><?php echo $this->renderPosition('tab-reviews', $positionParams); ?></div>
			    </li>
		    <?php endif; ?>

		    <?php if ($this->checkPosition('tab-comments')) : ?>
			    <li>
				    <div id="tab-comments"><?php echo $this->renderPosition('tab-comments', $positionParams); ?></div>
			    </li>
		    <?php endif; ?>
	    </ul>
    </div>

    <script type="text/javascript">
        jQuery(function ($) {
	        $('.uk-tab li:first-child, #tab-content > li:first-child').addClass('uk-active');
	        $('[data-uk-switcher]').on('uk.switcher.show', function(event, area){
		        console.log("Switcher switched to ", area);
	        });
        });
    </script>

<?php endif; ?>

<?php echo $this->renderPosition('related', array('style' => 'jbblock', 'labelTag' => 'h2', 'clear' => true)); ?>
