<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class ElementJBCartValue
 */
class ElementJBCartValue extends Element implements iSubmittable
{
    /**
     * @var JBCartValue
     */
    protected $_jbvalue = null;

    /**
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        if (class_exists('JBCart')) {

            if (is_null($this->_jbvalue)) {
                $value = $this->get('value', $this->config->get('default'));
                $this->_jbvalue = JBCart::val($value);
            }

            return !$this->_jbvalue->isEmpty();
        }

        return false;
    }

    /**
     * @return mixed
     */
    public function getSearchData()
    {
        if ($this->hasValue()) {
            return $this->_jbvalue->val();
        }

        return null;
    }

    /**
     * Renders the repeatable edit form field.
     * @return mixed
     */
    public function edit()
    {
        if (!class_exists('JBCart')) {
            return 'Element works only with JBZoo 220 or later';
        }

        return $this->app->html->_('control.text',
            $this->getControlName('value'),
            $this->get('value', $this->config->get('default')),
            'size="60" maxlength="60" placeholder="For example, 20 or 20usd"'
        );
    }


    /**
     * Renders the element in submission.
     * @param array $params
     * @return mixed
     */
    public function renderSubmission($params = array())
    {
        return $this->edit();
    }

    /**
     * @param array $params
     * @return string
     */
    public function render($params = array())
    {
        return $this->_jbvalue->html();
    }

    /**
     * @param $value
     * @param $params
     * @return array
     */
    public function validateSubmission($value, $params)
    {
        return array(
            'value' => $this->app->validator->create('textfilter', array(
                'required' => $params->get('required')
            ))->clean($value->get('value')));
    }

}