<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingFieldCheckbox
 */
class JBCartElementShippingFieldCheckbox extends JBCartElementShippingField
{
    /**
     * Render shipping in order
     * @param  array
     * @return bool|string
     */
    public function edit($params = array())
    {
        if ($layout = $this->getLayout('edit.php')) {
            return self::renderLayout($layout, array(
                'params'  => $params,
                'options' => (array)$this->get('options', array()),
            ));
        }

        return null;
    }

    /**
     * renders front-end submission
     * @param array $params
     * @return string
     */
    public function renderSubmission($params = array())
    {
        $list    = $this->config->get('options', '');
        $list    = $this->parseLines($list);
        if (count($list)) {

            /** @type JBHtmlHelper */
            $html[] = $this->app->jbhtml->checkbox($list, $this->getControlName('options', true));

            // workaround: if nothing is selected, the element is still being transfered
            $html[] = '<input type="hidden" name="' . $this->getControlName('checkbox') . '" value="1" />';

            return implode(PHP_EOL, $html);
        }

        return JText::_('There are no options to choose from.');
    }

    /**
     * Validates the submitted element
     * @param $value
     * @param $params
     * @return array
     */
    public function validateSubmission($value, $params)
    {
        $params = $this->app->data->create($params);
        $value  = $this->app->data->create($value);

        $required = array('required' => $params->get('required'));
        $messages = array('required' => 'Please choose an option.');

        $config_options = $this->parseLines($this->config->get('options', ''));
        $options        = (array)$value->get('options', array());
        $options        = $this->app->validator
            ->create('foreach', $this->app->validator->create('string', $required, $messages), $required, $messages)
            ->clean($options);

        if (count($options) !== 0) {
            foreach ($options as $key => $value) {
                if (!in_array($value, $config_options, true)) {
                    unset($options[$key]);
                }
            }
        }

        return compact('options');
    }

    /**
     * @todo Use helper
     * @param $text
     * @return array
     */
    protected function parseLines($text)
    {
        $text   = JString::trim($text);
        $result = array();
        if (!empty($text)) {
            $lines = explode("\n", $text);
            foreach ($lines as $line) {
                $line = JString::trim($line);

                $result[$line] = $line;
            }
        }

        return $result;
    }
}
