<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingFieldRadio
 */
class JBCartElementShippingFieldRadio extends JBCartElementShippingField
{
    /**
     * renders front-end submission
     * @param array $params
     * @return string
     */
    public function renderSubmission($params = array())
    {
        $list    = $this->config->get('options', '');
        $list    = $this->parseLines($list);
        if (count($list)) {

            /** @type JBHtmlHelper */
            $html[] = $this->app->jbhtml->radio($list, $this->getControlName('value'));

            // workaround: if nothing is selected, the element is still being transfered
            $html[] = '<input type="hidden" name="' . $this->getControlName('radio') . '" value="1" />';

            return implode(PHP_EOL, $html);
        }

        return JText::_('There are no options to choose from.');
    }

    /**
     * @todo Use helper
     * @param $text
     * @return array
     */
    protected function parseLines($text)
    {
        $text   = JString::trim($text);
        $result = array();
        if (!empty($text)) {
            $lines = explode("\n", $text);
            foreach ($lines as $line) {
                $line = JString::trim($line);

                $result[$line] = $line;
            }
        }

        return $result;
    }
}
