<?php
/**
* @package   ZOO Component
* @file      calcage.php
* @version   1.1 May 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) 2013 Likrion 
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/
        // no direct access
defined('_JEXEC') or die('Restricted access');
        /*
        Class: Elementcalcage
        */
class Elementcalcage extends Element implements iSubmittable {

	/*
		Function: hasValue
			Checks if the element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/

	public function hasValue($params = array()) {
		return $this->_data->get('value', true);
	}
	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return $this->app->html->_('zoo.calendar', $this->get('value', ''), $this->getControlName('value'), 'value', 'text', array('class' => 'calendar-element'), true);
	}
	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {

		if ($this->_data->get('value', true)) 
        {

                $now = new DateTime('now');
                $bday = $this->get('value');  
        }
        // render calcage
        return $now->diff(new DateTime($bday))->format('<span id="calcage">%y years %m mounth %d days</span>');
    } 

	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {
        return $this->edit();
	}

	/*
		Function: validateSubmission
			Validates the submitted element

	   Parameters:
            $value  - AppData value
            $params - AppData submission parameters

		Returns:
			Array - cleaned value
	*/
	public function validateSubmission($value, $params) {
		return array('value' => (bool) $value->get('value'));
	}
}