<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingTKEnergy
 */
class JBCartElementShippingTKEnergy extends JBCartElementShipping
{

    const CACHE_TTL = 1440;

    /**
     * @var string
     */
    protected $_currency = 'rub';

    /**
     * @return int
     */
    public function getRate()
    {
        $type  = $this->config->get('config');
        $summa = $this->_order->val(0, $this->_currency);

        $items = $this->_order->getItems();
        foreach ($items as $item) {

            $item = $this->app->data->create($item);

            $quantity = $item->get('quantity', 1);

            $height = (float)$item->find('elements._properties.height', 0.1) * $quantity;
            $weight = (float)$item->find('elements._properties.width', 0.1) * $quantity;
            $depth  = (float)$item->find('elements._properties.length', 0.1);
            $mass   = (float)$item->find('elements._weight', 0.1) * $quantity;

            $data = array(
                'method'     => 'nrg.calculate',
                'from'       => $this->config->get('sender'),
                'to'         => $this->get('city'),
                'weight'     => $mass,
                'height'     => $height,
                'width'      => $weight,
                'depth'      => $depth,
                'oversize'   => 0,
                'is_konvert' => 0,
                'volume'     => $height * $weight * $depth,
                'place'      => $quantity,
            );

            $resp = self::apiRequest($data);

            if ($resp['stat'] == 'ok') {

                $sumOne = null;
                foreach ($resp['values'] as $value) {
                    if ($resp['values'] == $type) {
                        $sumOne = $this->_order->val($value['price'], $this->_currency);
                    }
                }

                if (!$sumOne && isset($resp['values'][0])) {
                    $sumOne = $resp['values'][0]['price'];
                }

                $summa->add($sumOne);
            }
        }

        return $summa;
    }

    /**
     * @param $value
     * @param $params
     * @return mixed
     * @throws JBCartElementShippingException
     */
    public function validateSubmission($value, $params)
    {
        $cityId  = $value->get('city');
        $locList = $this->getLocationList();

        if (!$cityId || !isset($locList[$cityId])) {
            throw new JBCartElementShippingException('Укажите город для доставки');
        }

        $this->bindData($value);
        $value->set('rate', $this->getRate()->data(true));

        return $value;
    }

    /**
     * @param bool|false $full
     * @return array
     */
    public function getLocationList($full = false)
    {
        $senderCity = $this->config->get('sender');

        $list = self::apiRequest(array('method' => 'nrg.get.locations'));

        $locList = array('0' => ' - Выберите город - ');

        foreach ($list['locations'] as $loc) {
            $cityId = $loc['id'];

            if (!$full && $cityId == $senderCity) {
                continue;
            }

            $locList[$cityId] = $loc['name'];
        }

        return $locList;
    }

    /**
     * @param $params
     * @return mixed
     */
    public static function apiRequest($params)
    {
        /** @var JBHttpHelper $jbhttp */
        $jbhttp = App::getInstance('zoo')->jbhttp;

        $json = $jbhttp->request('http://api.nrg-tk.ru/api/rest/', $params, array(
            'cache'     => true,
            'cache_ttl' => self::CACHE_TTL,
        ));

        $result = json_decode($json, true);

        return isset($result['rsp']) ? $result['rsp'] : array();
    }

    /**
     * @param $name
     * @param $value
     * @param $controlName
     * @param $node
     * @param $parent
     * @return mixed
     */
    public static function getLocationSelect($name, $value, $controlName, $node, $parent)
    {
        $list = self::apiRequest(array('method' => 'nrg.get.locations'));

        $locList = array();
        foreach ($list['locations'] as $loc) {
            $cityId           = $loc['id'];
            $locList[$cityId] = $loc['name'];
        }

        return App::getInstance('zoo')->jbhtml->select($locList, $controlName . '[' . $name . ']', '', $value);
    }

    /**
     * @return AppParameterForm
     */
    public function getConfigForm()
    {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__) . '/fields');
    }
}
