<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementModifierOrderPriceMydiscount
 */
class JBCartElementModifierOrderPriceMydiscount extends JBCartElementModifierOrderPrice
{
    /**
     * @return JBCartValue
     */
    public function getRate()
    {
        $orderSum = $this->_order->getTotalForItems(); // получили сумму за все товары (без доставки и прочего)
        $discount = 0;

        if ($orderSum->compare($this->config->get('limit', 1000), '>=')) { // сравниваем c 2000 рублей
            $discount = $this->config->get('rate', 0);
        }

        return $this->_order->val($discount)->negative(); // обязательно вернуть объект, добавляем знак минус (чтобы была скидка)
    }

    /**
     * @param array $params
     * @return null|string
     */
    public function renderSubmission($params = array())
    {
        $rate     = $this->getRate();
        $total    = $this->getOrder()->getTotalForItems()->getClone();
        $discount = $total->getClone()->add($rate);

        if ($layout = $this->getLayout('submission.php')) {
            return self::renderLayout($layout, array(
                'rate'     => $rate,
                'total'    => $total,
                'discount' => $discount,
            ));
        }

        return null;
    }

}
