<?php
/**
* @package   com_zoo
* @file      kprating.php
* @version   1.0 July 2013
* @author    Likrion http://www.likrion.net
* @copyright Copyright (C) Likrion 2009 - 2013
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

        // no direct access
	defined('_JEXEC') or die('Restricted access');
        /*
        Class: Elementkprating
        */
	class Elementkprating extends Element {
		public function hasValue($params = array()) {
			return true;
		}
                /*
                Function: edit
                Renders the edit form field.
                
                Returns:
                String - html
                */
		public function edit() {
			return $this->app->html->_('control.text', $this->getControlName('movie'), $this->get('movie'));
		}
                /*
                Function: render
                Override. Renders the element.
                
                Parameters:
                $params - render parameter
                
                Returns:
                String - html
                */
		public function render($params = array()) {
			if (!empty ($this->_item)) {
				$this->app->document->addStylesheet('elements:kprating/assest/css/kprating.css');
				$kpid = $this->_data->get('movie');
				$folder = $this->app->path->path('elements:kprating/assest/xml/');
				$lfile = $folder . '/' . $kpid . '.xml';
				$rfile = file_get_contents('http://www.kinopoisk.ru/rating/' . $kpid . '.xml');
				(file_exists($lfile)) ? null : file_put_contents($lfile, $rfile);
				$xml = simplexml_load_file($lfile);
                                $kpr = 0;
                                $imdbr = 0;
				foreach ($xml->xpath('/rating/kp_rating') as $kpr);
				foreach ($xml->xpath('/rating/imdb_rating') as $imdbr);
				if (!empty ($kpid)) {
					return $html[] = "
                            <div class='clearfix'>
                                 <div>
                                      <div class='star'><small>$kpr</small></div>
                                      <div class='kprating'>rating kinopoisk<br/><strong>$kpr ($kpr[num_vote] votes)</strong></div>
                                 </div>
                                 <div>
                                      <div class='star'><small>$imdbr</small></div>
                                      <div class='kprating'>rating IMDB<br/><strong>$imdbr ($imdbr[num_vote]  votes)</strong></div>
                                 </div>
                            </div>";
				}
				else {
					return null;
				}
			}
		}
	}