<?php

defined('_JEXEC') or die('Restricted access');
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

class Elementglink extends ElementRepeatable implements iRepeatSubmittable {

	protected function _hasValue($params = array()) {
		$link = $this->get('value', '');
		return !empty($link);
	}

	public function getText() {
		$text = $this->get('text', '');
		return empty($text) ? $this->get('value', '') : $text;
	}

	public function getTitle() {
		$title = $this->get('custom_title', '');
		return empty($title) ? $this->getText() : $title;
	}
	public function getClass() {
		$title = $this->get('class', '');
		return empty($class) ? $this->get('class', '') : $class;
	}


	protected function _render($params = array()) {
                    
                $this->app->document->addStylesheet('elements:glink/glink.css');
		$target = ($this->get('target', '')) ? 'target="_blank"' : '';
		$rel	= $this->get('rel', '');
		$rel	= !empty($rel) ? 'rel="' . $rel .'"' : '';

		return '<a class="'.$this->getClass().'" href="'.JRoute::_($this->get('value', '')).'" title="'.$this->getTitle().'" '.$target.' '. $rel .'>'.$this->getText().'</a>';

	}

	protected function _edit(){
		return $this->_editForm();
	}

	public function _renderSubmission($params = array()) {
        return $this->_editForm($params->get('trusted_mode'));
	}

	protected function _editForm($trusted_mode = true) {
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout,
                compact('trusted_mode')
            );
        }
	}

	public function _validateSubmission($value, $params) {
        $values       = $value;

        $validator    = $this->app->validator->create('string', array('required' => false));
        $text         = $validator->clean($values->get('text'));
        $target       = $validator->clean($values->get('target'));
        $custom_title = $validator->clean($values->get('custom_title'));
        $rel          = $validator->clean($values->get('rel'));
        $class        = $validator->clean($values->get('class'));
        $value        = $this->app->validator
				->create('url', array('required' => $params->get('required')), array('required' => 'Please enter an URL.'))
				->clean($values->get('value'));

		return compact('value', 'text', 'target', 'custom_title', 'rel', 'class');
    }

}