<?php

/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Sergey Kalistratov <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCartElementOrderComProfiler
 */
class JBCartElementOrderComProfiler extends JBCartElementOrder
{

    /**
     * Element constructor.
     *
     * @param App $app
     * @param string $type
     * @param string $group
     */
    public function __construct($app, $type, $group)
    {
        parent::__construct($app, $type, $group);
        $this->_loadLangs();
    }

    /**
     * Render submission.
     *
     * @param array $params
     * @return bool|mixed|string
     */
    public function renderSubmission($params = array())
    {
        $tmpl = $this->config->get('tmpl', 'text');
        $args = array('params' => $params);

        if ($layout = $this->getLayout('submission_' . $tmpl . '.php')) {

            $user = JFactory::getUser();
            if ($this->hasCB()) {
                if ($user && $user->id) {
                    $cbUser = CBuser::getInstance($user->id);
                    $args['user'] = clone $cbUser->_cbuser;

                    if ($this->config->get('user_field') == 'formatname') {
                        $args['user']->formatname = $user->name;
                    }

                }
            } else {
                $args['user'] = $user;
            }

            return self::renderLayout($layout, $args);
        }

        return false;
    }

    /**
     * Check init Community Builder
     *
     * @return bool
     */
    public function hasCB()
    {
        $foundationFile = JPATH_ADMINISTRATOR . '/components/com_comprofiler/plugin.foundation.php';

        if (file_exists($foundationFile)) {
            include_once($foundationFile);

            if (class_exists('CBuser')) {
                return true;
            }

        }

        return false;
    }

    /**
     * @return AppParameterForm
     */
    public function getConfigForm()
    {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__) . '/fields');
    }

}
