<?php

/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Sergey Kalistratov <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCartElementShippingFieldUserCustom
 */
class JBCartElementShippingFieldUserCustom extends JBCartElementShippingField
{
    /**
     * @var array
     */
    protected $_customFields = array(
        'fio',
        'phone',
        'city',
        'address',
        'flat',
        'bonus',
    );

    /**
     * Element constructor.
     *
     * @param App    $app
     * @param string $type
     * @param string $group
     */
    public function __construct($app, $type, $group)
    {
        parent::__construct($app, $type, $group);
        $this->_loadLangs();
    }

    /**
     * Render submission.
     *
     * @param array $params
     * @return bool|mixed|string
     */
    public function renderSubmission($params = array())
    {
        $tmpl = $this->config->get('tmpl', 'text');

        if ($layout = $this->getLayout('submission_' . $tmpl . '.php')) {

            $user = JFactory::getUser();

            return self::renderLayout($layout, array(
                'params' => $params,
                'user'   => $user,
            ));
        }

        return false;
    }

    /**
     * @return AppParameterForm
     */
    public function getConfigForm()
    {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__) . '/fields');
    }

    /**
     * @return array
     */
    public function getCustomFields()
    {
        return $this->_customFields;
    }

}
