<?php
/**
 * MyZooItems - CommunityBuilder plugin displays a tab with the last user ZOO posts
 *
 * @version 1.0.5
 * @package ZOO plugin for CommunityBuilder
 * @author Attavus M.D. (webmaster@raslab.org)
 * @copyright (C) 2013 R.A.S.Lab[.org] (http://www.raslab.org)
 * @license http://opensource.org/licenses/GPL-2.0 GNU/GPLv2 only
 *
 **/

// no direct access
defined('_JEXEC') or die('Restricted access');

class MyZOOItemsTab extends cbTabHandler {

	function MyZOOItemsTab() 	{
		$this->cbTabHandler();
	}//function

	/**
	* Generates the HTML to display the user profile tab
	* @param object tab reflecting the tab database entry
	* @param object mosUser reflecting the user being displayed
	* @param int 1 for front-end, 2 for back-end
	* @returns mixed : either string HTML for tab content, or false if ErrorMSG generated
	*/

	function getDisplayTab($tab, $user, $ui) {
		
		// init vars
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');		
		$zoo       = App::getInstance('zoo');
		//$params    = $zoo->parameter->create($tab->params);		
		$def_limit = (int) trim($this->params->get('item_count', 10));
		$paging    = $this->params->get('paging', 1);
		//$zoo->system->application->enqueueMessage(__LINE__.': $params: '.json_encode($params));
		//$zoo->system->application->enqueueMessage(__LINE__.': $tab: '.json_encode(print_r($tab)));
		// We need to load the language code here since some plugin
		// apparently modify this before language code is loaded		
		$zoo->system->language->load('com_zoo');

		if ($tab->description != null) $return .= "<div class=\"tab_Description\">".$tab->description."</div>";

		$pagingParams = $this->_getPaging(array(),array("myzooitems_"));
		if ($paging) {
			$total = $this->_getItemsCount($zoo, (int) $user->id, $this->params);
			if (!is_numeric($total)) $total = 0;
			if (!isset($pagingParams["myzooitems_limitstart"])) $pagingParams["myzooitems_limitstart"] = "0";
			if ($def_limit > $total) $pagingParams["myzooitems_limitstart"] = "0";
		}

		$items = $this->_getItems($zoo, (int) $user->id, $pagingParams["myzooitems_limitstart"], $def_limit, $this->params);
		$html = "";
		ob_start();
		?>
			<div class="yoo-zoo">
			<?php if (!empty($items)) : ?>
				<div class="items">
				<?php foreach ($items as $item) : ?>
					<div class="item">
						<?php $item_html = null;
						if($this->params->get('item_view', 'layout') == 'layout') {
							$renderer = $zoo->renderer->create('item')->addPath(array($zoo->path->path('component.site:'), $item->getApplication()->getTemplate()->getPath()));
							$path   = 'item';
							$prefix = 'item.';
							$type   = $item->getType()->id;
							if ($renderer->pathExists($path.DIRECTORY_SEPARATOR.$type)) {
								$path   .= DIRECTORY_SEPARATOR.$type;
								$prefix .= $type.'.';
							}
							if (in_array('teaser', $renderer->getLayouts($path))) {
								$item_html = $renderer->render($prefix.'teaser', array('view' => $item->getApplication(), 'item' => $item));
							} elseif (in_array('related', $renderer->getLayouts($path))) {
								$item_html = $renderer->render($prefix.'related', array('view' => $item->getApplication(), 'item' => $item));
							}
						} elseif (empty($item_html) || $this->params->get('item_view', 'layout') == 'name'){
							$item_html = '<a href="'.$zoo->route->item($item).'" title="'.$item->name.'">'.$item->name.'</a>';
						}
						echo $item_html; ?>
						<div style='border-bottom:1px solid #CCCCCC; margin-bottom:4px;with:100%;'></div>
					</div>
				<?php endforeach; ?>
				</div>
				<?php if ($paging && $total > $def_limit):?>
					<!-- Start Pagination -->
					<div style='width:95%;text-align:center;'>
						<?php echo $this->_writePaging($pagingParams,"myzooitems_", $def_limit, $total);?>
					</div>
					<!-- End Pagination -->
				<?php endif; ?>
			<?php else : ?>
				<div class="no-items">
					<?php echo JText::_('PLG_MYZOOITEMS_NO_ITEMS'); ?>
				</div>
			<?php endif; ?>
			</div>
		<?php
		$html = ob_get_contents();
		ob_end_clean();
		return $html;
	}//function

	private function _getItems($zoo, $user_id, $offset = 0, $limit = 0, $params) {
		// get query
		$options = array('select' => 'a.*',
						'from' => ZOO_TABLE_ITEM.' AS a'
						.' LEFT JOIN '.ZOO_TABLE_TAG.' AS b ON a.id = b.item_id'
						.' LEFT JOIN '.ZOO_TABLE_CATEGORY_ITEM.' AS c ON a.id = c.item_id',
						'conditions' => $this->_getConditions($zoo, $user_id, $params),
						'order' => $params->get('item_order', 'a.priority DESC'));
		if ($limit != 0) {
			$options['offset'] = (int) $offset;
			$options['limit'] = (int) $limit;
		}		
		// return items
		//$zoo->system->application->enqueueMessage(__LINE__.': $items: '.json_encode($zoo->table->item->all($options)));
		//$zoo->system->application->enqueueMessage(__LINE__.': $options: '.json_encode($options));		
		return $zoo->table->item->all($options);
	}

	private function _getItemsCount($zoo, $user_id, $params) {
		// get database
		$db = $zoo->database;		
		// get query
		$query = $db->getQuery(true);
		$query->select('a.id')->from(ZOO_TABLE_ITEM.' AS a')
				->leftJoin(ZOO_TABLE_TAG.' AS b ON a.id = b.item_id')
				->leftJoin(ZOO_TABLE_CATEGORY_ITEM.' AS c ON a.id = c.item_id')
				->where($this->_getConditions($zoo, $user_id, $params))
				->group('a.id');
		$db->query($query);
		$count = $db->getNumRows();
		//$zoo->system->application->enqueueMessage(__LINE__.': $count: '.json_encode($count));
		return $count;
	}

	private function _getConditions($zoo, $user_id, $params) {		
		// get database
		$db = $zoo->database;		
		// set base query options		
		$conditions = "a.".$zoo->user->getDBAccessString($zoo->user->get());
		// ... by applications
		if(($applications = $params->get('zooapplications')) && !empty($applications)) {
			//$zoo->system->application->enqueueMessage(__LINE__.': $applications: '.json_encode($applications));
			$applicationIds = array();
			$applications = explode("|*|", $applications);
			//$zoo->system->application->enqueueMessage(__LINE__.': $applications2: '.json_encode($applications));
			foreach($applications as $id) {
				//$zoo->system->application->enqueueMessage(__LINE__.': $id: '.json_encode($id));
				if(!empty($id)) {
					$applicationIds[] = $db->Quote((int) $id);
				}
			}
			if(!empty($applicationIds)) {
				$conditions .= " AND a.application_id".($params->get('zooapplications_selection', 0) ? "" : " NOT")." IN (".implode(', ', $applicationIds).")";
				//$zoo->system->application->enqueueMessage(__LINE__.': $conditions: '.json_encode($conditions));
			}
		}
		// ... by types
		if(($types = $params->get('zootypes')) && !empty($types)) {			
			$typeIds = array();
			$types = explode("|*|", $types);
			foreach($types as $id) {
				if(!empty($id)) {
					$typeIds[] = $db->Quote($db->escape((string) $id));
				}
			}
			if(!empty($typeIds)) {
				$conditions .= " AND a.type".($params->get('zootypes_selection', 0) ? "" : " NOT")." IN (".implode(', ', $typeIds).")";
			}
		}
		// ... by categories
		if(($categories = $params->get('zoocategories')) && !empty($categories)) {
			$categoryIds = array();
			$categories = explode("|*|", $categories);
			foreach($categories as $id) {
				if(!empty($id)) {
					$categoryIds[] = $db->Quote((int) $id);
				}
			}
			if(!empty($categoryIds)) {
				$conditions .= " AND c.category_id".($params->get('zoocategories_selection', 0) ? "" : " NOT")." IN (".implode(', ', $categoryIds).")";
			}
		}		
		// ... by author
		$conditions .= " AND a.created_by = ".$db->Quote($db->escape((int) $user_id));
		// ... expired
		if(!$params->get('expired', 0)) {
			// get dates and prepare
			$date = $zoo->date->create();
			$now  = $db->Quote($date->toSQL());
			$null = $db->Quote($db->getNullDate());
			$conditions .= " AND (a.publish_up = ".$null." OR a.publish_up <= ".$now.")" 
						." AND (a.publish_down = ".$null." OR a.publish_down >= ".$now.")";
		}
		// ... published
		if($params->get('published', 1)) {			
			$conditions .= " AND a.state = 1";
		}
		//$zoo->system->application->enqueueMessage(__LINE__.': $conditions: '.json_encode($conditions));
		return $conditions;
	}

	/**
	 * Function for the backend XML
	 *
	 * @param  string  $name          Name of the control
	 * @param  string  $value         Current value
	 * @param  string  $control_name  Name of the controlling array (if any)
	 * @return string                 HTML for the control data part or FALSE in case of error
	 */
	function loadExistingZooApplications($name, $value, $control_name) {
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
		$zoo = App::getInstance('zoo');
		//$zoo->system->application->enqueueMessage(__LINE__.': loadExistingZooApplications: '.json_encode($value));
		// add chosen in Joomla 2.5
		if ($zoo->joomla->isVersion('2.5')) {
			$zoo->document->addScript('libraries:jquery/plugins/chosen/chosen.jquery.min.js');
			$zoo->document->addStylesheet('libraries:jquery/plugins/chosen/chosen.css');
		} else {
			$zoo->html->_('formbehavior.chosen', '#paramszooapplications');
		}
		// init vars
		$value = (isset($value)) ? array_map(create_function('$v', '$o=new stdClass(); $o->value=$v; return $o;'), explode("|*|", $value )) : null;
		$options  = array();
		$attribs  = ' class="inputbox"';
		$attribs .= ' style="width: 175px;"';
		$attribs .= ' multiple="multiple"';
		$attribs .= ' data-no_results_text="'.JText::_('NO_RESULTS').'"';
		$attribs .= ' data-placeholder="'.JText::_('СHOOSE').'"';
		// create application/submission/type select
		$options[] = $zoo->html->_('select.option', '', '');

		foreach ($zoo->application->getApplications() as $application) {
			$options[] = $zoo->html->_('select.option', $application->id, $application->name);
		}

		$html = $zoo->html->_('select.genericlist', $options, $control_name.'['.$name.'][]', trim($attribs), 'value', 'text', $value, $control_name.$name);
		$html .= '<script type="text/javascript"> jQuery(function($){';
		if ($zoo->joomla->isVersion('2.5')) {
			$html .= '$("#paramszooapplications").chosen({ disable_search_threshold : 10, allow_single_deselect : true });';
		}
		// add here since on 3.0 the options are hardcoded in the constructor of the PHP method
		$html .= '$("#paramszooapplications").data("chosen").search_contains = true;';
		$html .= '}); </script>';

		return $html;
	}

	/**
	 * Function for the backend XML
	 *
	 * @param  string  $name          Name of the control
	 * @param  string  $value         Current value
	 * @param  string  $control_name  Name of the controlling array (if any)
	 * @return string                 HTML for the control data part or FALSE in case of error
	 */
	function loadExistingZooTypes($name, $value, $control_name) {
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
		$zoo = App::getInstance('zoo');
		//$zoo->system->application->enqueueMessage(__LINE__.': loadExistingZooTypes: '.json_encode($value));
		// add chosen in Joomla 2.5
		if ($zoo->joomla->isVersion('2.5')) {
			$zoo->document->addScript('libraries:jquery/plugins/chosen/chosen.jquery.min.js');
			$zoo->document->addStylesheet('libraries:jquery/plugins/chosen/chosen.css');
		} else {
			$zoo->html->_('formbehavior.chosen', '#paramszootypes');
		}
		// init vars
		$value = (isset($value)) ? array_map(create_function('$v', '$o=new stdClass(); $o->value=$v; return $o;'), explode("|*|", $value )) : null;
		$options  = array();
		$attribs  = ' class="inputbox"';
		$attribs .= ' style="width: 175px;"';
		$attribs .= ' multiple="multiple"';
		$attribs .= ' data-no_results_text="'.JText::_('NO_RESULTS').'"';
		$attribs .= ' data-placeholder="'.JText::_('СHOOSE').'"';
		// create application/type select
		$options[] = $zoo->html->_('select.option', '', '');

		foreach ($zoo->application->getApplications() as $application) {
			// get types
			$types = $application->getTypes();
			if (count($types)) {
				$options[] = $zoo->html->_('select.option', '<OPTGROUP>', JText::_('Application').' '.$application->name);			
				// create types select
				foreach ($types as $type) {
					$options[] = $zoo->html->_('select.option', $type->id, $type->name);
				}
				$options[] = $zoo->html->_('select.option', '</OPTGROUP>');					
			}
		}

		$html = $zoo->html->_('select.genericlist', $options, $control_name.'['.$name.'][]', trim($attribs), 'value', 'text', $value, $control_name.$name);
		$html .= '<script type="text/javascript"> jQuery(function($){';
		if ($zoo->joomla->isVersion('2.5')) {
			$html .= '$("#paramszootypes").chosen({ disable_search_threshold : 10, allow_single_deselect : true });';
		}
		// add here since on 3.0 the options are hardcoded in the constructor of the PHP method
		$html .= '$("#paramszootypes").data("chosen").search_contains = true;';
		$html .= '}); </script>';

		return $html;
	}

	/**
	 * Function for the backend XML
	 *
	 * @param  string  $name          Name of the control
	 * @param  string  $value         Current value
	 * @param  string  $control_name  Name of the controlling array (if any)
	 * @return string                 HTML for the control data part or FALSE in case of error
	 */
	function loadExistingZooCategories($name, $value, $control_name) {
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');
		$zoo = App::getInstance('zoo');
		//$zoo->system->application->enqueueMessage(__LINE__.': loadExistingZooCategories: '.json_encode($value));
		// add chosen in Joomla 2.5
		if ($zoo->joomla->isVersion('2.5')) {
			$zoo->document->addScript('libraries:jquery/plugins/chosen/chosen.jquery.min.js');
			$zoo->document->addStylesheet('libraries:jquery/plugins/chosen/chosen.css');
		} else {
			$zoo->html->_('formbehavior.chosen', '#paramszoocategories');
		}
		// init vars
		$value = (isset($value)) ? array_map(create_function('$v', '$o=new stdClass(); $o->value=$v; return $o;'), explode("|*|", $value )) : null;
		$options  = array();
		$attribs  = ' class="inputbox"';
		$attribs .= ' style="width: 175px;"';
		$attribs .= ' multiple="multiple"';
		$attribs .= ' data-no_results_text="'.JText::_('NO_RESULTS').'"';
		$attribs .= ' data-placeholder="'.JText::_('СHOOSE').'"';
		// create application/categories select
		$options[] = $zoo->html->_('select.option', '', '');

		foreach ($zoo->application->getApplications() as $application) {
			// get categories
			$categories = $application->getCategories();
			if (count($categories)) {
				$options[] = $zoo->html->_('select.option', '<OPTGROUP>', JText::_('Application').' '.$application->name);			
				// create types select
				foreach ($categories as $category) {
					$options[] = $zoo->html->_('select.option', $category->id, $category->name);
				}
				$options[] = $zoo->html->_('select.option', '</OPTGROUP>');					
			}
		}

		$html = $zoo->html->_('select.genericlist', $options, $control_name.'['.$name.'][]', trim($attribs), 'value', 'text', $value, $control_name.$name);
		$html .= '<script type="text/javascript"> jQuery(function($){';
		if ($zoo->joomla->isVersion('2.5')) {
			$html .= '$("#paramszoocategories").chosen({ disable_search_threshold : 10, allow_single_deselect : true });';
		}
		// add here since on 3.0 the options are hardcoded in the constructor of the PHP method
		$html .= '$("#paramszoocategories").data("chosen").search_contains = true;';
		$html .= '}); </script>';

		return $html;
	}
}
