<?php
/**
* @package   ZOO Component
* @file      zootoolbar.php
* @version   2.5.0.0 February 2012
* @author    Attavus M.D. http://www.raslab.org
* @copyright Copyright (C) 2011 R.A.S.Lab[.org]
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSystemZooToolBar extends JPlugin
{

	public $app;
	
	/**
	 * onAfterInitialise handler
	 *
	 * Adds ZOO event listeners
	 *
	 * @access public
	 * @return null
	 */
	function onAfterInitialise(){
	
		// make sure ZOO exist
		jimport('joomla.filesystem.file');
		if (!JFile::exists(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php')
				|| !JComponentHelper::getComponent('com_zoo', true)->enabled) {
			return;
		}	
		
		// load zoo
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');		
		
		// check if Zoo > 2.4 is loaded
		if (!class_exists('App')) {
			return;
		}
	
		// Get the ZOO App instance
		$this->app = App::getInstance('zoo');
		
		//Load languagefile to make translations work
		$this->loadLanguage();
		
		if ($this->app->system->application->isSite()) {
			return;
		}
		
		// register plugin path
		if ($path = $this->app->path->path('root:plugins/system/zootoolbar/') ) {
			$this->app->path->register($path, 'zootoolbar');
		}
		
		// register controllers
		if ($path = $this->app->path->path('zootoolbar:controllers/')) {
			$this->app->path->register( $path, 'controllers' );
		}
	}
	
	/**
	* Do something onBeforeRender
	*/
	function onBeforeRender () {
		// load application
		$application = $this->app->zoo->getApplication();		
		// is application ?
		if (!empty($application) && $this->app->request->getCmd('option') == 'com_zoo'
						&& $this->app->request->getCmd('controller') == 'item'
						&& $this->app->system->application->isAdmin()) {
			$bar=& JToolBar::getInstance( 'toolbar' );
			$bar->appendButton('Separator');
			$bar->appendButton('Link', 'publish', JText::_('PLG_ZOOTOOLBAR_PUBLISH_ITEMS'), 'index.php?option='.$this->app->component->self->name.'&controller=toolbar&task=publish&tmpl=component');
			$bar->appendButton('Link', 'unpublish', JText::_('PLG_ZOOTOOLBAR_UNPUBLISH_ITEMS'),'index.php?option='.$this->app->component->self->name.'&controller=toolbar&task=unpublish&tmpl=component');
			$bar->appendButton('Link', 'save', JText::_('PLG_ZOOTOOLBAR_RESAVE_ITEMS'),'index.php?option='.$this->app->component->self->name.'&controller=toolbar&task=resave&tmpl=component');
		}
	}
}
