<?php
/**
* @package   ZOO Component
* @file      zootoolbar.php
* @author    Attavus M.D. http://www.raslab.org
* @copyright Copyright (C) 2012 R.A.S.Lab[.org]
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

/*
	Class: ToolBarController
		The controller class for zootoolbar tasks
*/
class ToolBarController extends AppController {
	
	public $application;
	
	public function __construct($default = array()) {
		parent::__construct($default);

		// get application
		$this->application 	= $this->app->zoo->getApplication();

		// set base url
		$this->baseurl = $this->app->link(array('controller' => 'item'), false);
	}

	public function publish() {				
		if(!empty($this->application)) {			
			$query = $this->app->database->getQuery(true);
			$query->update(ZOO_TABLE_ITEM);
			$query->set('state = 1');
			$query->where('application_id = '.$this->application->id);
			$ok = $this->app->database->query($query);			
			$this->setRedirect($this->baseurl, $ok ? JText::_('PLG_ZOOTOOLBAR_ITEMS_SUCCESS_PUBLISHED') : JText::_('Items is not successfully published'));
		}
		return;
	}
	
	public function unpublish() {		
		if(!empty($this->application)) {			
			$query = $this->app->database->getQuery(true);
			$query->update(ZOO_TABLE_ITEM);
			$query->set('state = 0');
			$query->where('application_id = '.$this->application->id);
			$ok = $this->app->database->query($query);
			$this->setRedirect($this->baseurl, $ok ? JText::_('PLG_ZOOTOOLBAR_ITEMS_SUCCESS_UNPUBLISHED') : JText::_('PLG_ZOOTOOLBAR_ITEMS_NOTSUCCESS_UNPUBLISHED'));
		}
		return;
	}
	
	public function toolbar() {
		//null
	}

	public function resave() {
		$ok = true;		
		// set query options
		$options = ($this->application->id !== false ? "application_id = ".(int) $this->application->id : "")
			." AND ".$this->app->user->getDBAccessString($this->app->user->get());		
		foreach($this->app->table->item->all($options) as $item)
		{
			if(!$this->app->table->item->save($item)) $ok = false;
		}
		$this->setRedirect($this->baseurl, $ok ? JText::_('PLG_ZOOTOOLBAR_ITEMS_SUCCESS_RESAVED') : JText::_('PLG_ZOOTOOLBAR_ITEMS_NOTSUCCESS_RESAVED'));
	}
}

/*
	Class: ToolBarControllerException
*/
class ToolBarControllerException extends AppException {}
