<?php
/*************************
* @package   ZOO Component
* @file      itemremove.php
* @version   3.0.1 March 2013
* @author    Attavus M.D. http://www.raslab.org
* @copyright Copyright (C) 2013 R.A.S.Lab[.org]
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*******************************************************************/

// no direct access
defined('_JEXEC') or die('Restricted access');

/*
  Class: ElementItemRemove
     the itemremove element class
*/
class ElementItemRemove extends Element {

	/*
		Function: hasValue
			Override. Checks if the element's value is set.

	   Parameters:
			$params - AppData render parameter

		Returns:
			Boolean - true, on success
	*/
	public function hasValue($params = array()) {
		// Check if the user can access the sub itself and if an item edit submission is set
		return $this->getItem() 
				&& ($submission = $this->getItem()->getApplication()->getItemEditSubmission()) 
				&& $submission->canAccess();
	}

	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - AppData render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {

		// render layout
		if ($layout = $this->getLayout()) {

			// Get the item edit submission
			if ($submission = $this->getItem()->getApplication()->getItemEditSubmission()) {
				return $this->renderLayout($layout, array(
					'item' => $this->getItem(),
					'submission' => $submission
					)
				);
			}
		}
	}
	
	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return null;
	}
}
