<?php
/**
* @package   ZOO Component
* @file      addthisitem.php
* @version   3.0.0 December 2012
* @author    Attavus M.D. http://www.raslab.org
* @copyright Copyright (C) 2012 R.A.S.Lab[.org]
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

/*
	Class: ElementAddThisItem
		the addthisitem element class
*/
class ElementAddThisItem extends Element implements iSubmittable {
	
	/*
	   Function: Constructor
	*/
	public function __construct() {
		
		parent::__construct();
		
		// load language
		$this->loadLanguage();		
				
	}
			
	/*
		Function: hasValue
			Checks if the element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/
	public function hasValue($params = array()) {
		return (bool) $this->get('value', $this->config->get('default'));
	}
			
	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return $this->app->html->_('select.booleanlist', $this->getControlName('value'), '', $this->get('value', $this->config->get('default')));
	}			
					
	/*
		Function: render
			Renders the element.

	    Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {		
		// load assets
		$this->loadSiteAssets();
									
		// init display params
		$params = $this->app->data->create($params);					
		
		if ($this->get('value', $this->config->get('default'))) {
			// render layout
			if ($layout = $this->getLayout()) {
				return $this->renderLayout($layout, compact('params'));
			}
		}

		return null;

	}
	
	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {
        return $this->edit();
	}

	/*
		Function: validateSubmission
			Validates the submitted element

	   Parameters:
            $value  - AppData value
            $params - AppData submission parameters

		Returns:
			Array - cleaned value
	*/
	public function validateSubmission($value, $params) {
		return array('value' => $value->get('value'));
	}
	
	/*
		Function: loadSiteAssets
			Load elements css/js assets.

		Returns:
			Void
	*/
	public function loadSiteAssets() {
		// init vars
		$element = strtolower($this->getElementType());
		$application = $this->_item->getApplication();		
		$path = 'applications:'.$application->getGroup().'/elements/'.$element.'.php';		
		
		// load assets css			
		if (JFile::exists($this->app->path->path($path))) {	
			// css
			$this->app->document->addStylesheet('applications:'.$application->getGroup().'/elements/'.$element.'/assets/css/'.$element.'.css');				
		} else {
			$this->app->document->addStylesheet('elements:'.$element.'/assets/css/'.$element.'.css');		
		}	
		// load assets js
		/*	var addthis_config = {
			   services_custom:
			   [{name: "myyaru",
			   url: "http://my.ya.ru/posts_add_link.xml?URL={{URL}}&title={{TITLE}}&body=",
			   icon: "http://favicon.yandex.net/favicon/clubs.ya.ru"
			   },   {name: "liveinternetru",
				  url: "http://www.liveinternet.ru/journal_post.php?action=n_add&cnurl={{URL}}&cntitle={{TITLE}}",
				  icon: "http://i.li.ru/images/icons/16.gif"
				  } ]
			}			
			<!-- custom buttons -->
			<a class="addthis_button_my.ya.ru" rel="nofollow" title="Добавить на Я.ру"></a>
			<a class="addthis_button_www.liveinternet.ru" rel="nofollow" title="Добавить на Liveinternet.ru"></a>
			*/
		$this->app->system->document->addScriptDeclaration('var addthis_config = {"data_track_clickback":true};');
		$this->app->system->document->addScript('http://s7.addthis.com/js/250/addthis_widget.js#pubid='.$this->config->get('pubKey'));
		$vkapiId = $this->config->get('vkapiId');
		if (($this->config->get('userapi', 1) == 1) && !empty($vkapiId)) {
			$this->app->system->document->addScriptDeclaration('VK.init({apiId: '.$vkapiId.', onlyWidgets: true});');
			$this->app->system->document->addScript('http://userapi.com/js/api/openapi.js?52');
		}	
	}
	
	/*
		Function: loadLanguage
			Load elements language file.

		Returns:
			Void
	*/
	public function loadLanguage() {
		// init vars						
		$element = strtolower($this->getElementType());
		$path    = $this->app->path->path('elements:'.$element);
		$jlang   = $this->app->system->language;		
		// lets load first english, then joomla default standard, then user language
		$jlang->load('com_zoo.element.'.$element, $path, 'en-GB', true);
		$jlang->load('com_zoo.element.'.$element, $path, $jlang->getDefault(), true);
		$jlang->load('com_zoo.element.'.$element, $path, null, true);
	}
}
