<?php
/**
 * @package   ZOO Quick Icons
 * @author    YOOtheme http://www.yootheme.com
 * @copyright Copyright (C) YOOtheme GmbH
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// load config
jimport('joomla.filesystem.file');
if (!JFile::exists(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php') || !JComponentHelper::getComponent('com_zoo', true)->enabled) {
	return;
}

require_once JPATH_ADMINISTRATOR.'/components/com_zoo/config.php';
require_once JPATH_ROOT.'/media/zoo/applications/jbuniversal/framework/jbzoo.php';

// make sure App class exists
if (!class_exists('App')) {
	return;
}

$zoo = App::getInstance('zoo');

// JBZoo >= 2.2
if ((float)$zoo->jbversion->jbzoo() < '2.2') {
	return;
}

$paramCalendar = (int)$params->get('show_calendar');
$paramStat = (int)$params->get('show_stat');
$paramOrders = (int)$params->get('show_orders');
$paramCountOrders = (int)$params->get('orders_count');

$orderModel = JBModelOrder::model();

$graphRows = $orderModel->countByDate();
$ordersSum = $orderModel->getTotalSum();
$ordersCount = $orderModel->getCount();

$filter = array(
	'limit' => $paramCountOrders,
);

$orders = $orderModel->getList($filter);

?>

<div class="fl-jbzoo-orders">
	<?php if ($paramCalendar) : ?>
		<script type="text/javascript" src="https://www.google.com/jsapi"></script>
		<script type="text/javascript">
		    google.load("visualization", "1.1", {packages: ["calendar"]});
		    google.setOnLoadCallback(drawChart);

		    function drawChart() {
		        var dataTable = new google.visualization.DataTable();
		        dataTable.addColumn({type: 'date', id: 'date'});
		        dataTable.addColumn({type: 'number', id: 'sales'});
		        dataTable.addRows([
		            <?php foreach($graphRows as $row) : ?>
		            [new Date(<?php echo $row->year;?>, <?php echo $row->month - 1;?>, <?php echo $row->day;?>),
		                <?php echo $row->count;?>],
		            <?php endforeach;?>
		        ]);

		        var chart = new google.visualization.Calendar(document.getElementById('calendar_basic'));

		        var options = {
		            title   : "<?php echo JText::_('JBZOO_ADMIN_INDEX_GRAPH_TITLE'); ?>",
		            calendar: {
		                daysOfWeek: 'ВПВСЧПС'
		            }

		        };

		        chart.draw(dataTable, options);
		    }
		</script>
		<div id="calendar_basic"></div>
	<?php endif; ?>

	<?php if ($paramStat && $ordersCount) : ?>
		<div>
			<h2><?php echo JText::_('JBZOO_ADMIN_INDEX_SHOP_STATS'); ?></h2>
		    <p>
		        <?php echo JText::_('JBZOO_ADMIN_INDEX_ORDERS_SUM'); ?>: <?php echo $ordersSum; ?><br />
		        <?php echo JText::_('JBZOO_ADMIN_INDEX_ORDERS_COUNT'); ?>: <?php echo $ordersCount; ?>
		    </p>
		</div>
	<?php endif; ?>

	<?php if ($paramOrders && !empty($orders)) {

	    $html = array(
	        '<h2>' . $paramCountOrders . ' последних заказов</h2>',
	        '<table class="uk-table uk-table-hover uk-table-striped uk-table-condensed"><thead><tr>',
	        '<th>' . JText::_('JBZOO_ADMIN_NAME') . '</th>',
	        '<th>' . JText::_('JBZOO_ADMIN_CREATED') . '</th>',
	        '<th>' . JText::_('JBZOO_ADMIN_STATUS') . '</th>',
	        '<th>' . JText::_('JBZOO_ADMIN_TOTAL') . '</th>',
	        '<th>' . JText::_('JBZOO_ADMIN_ORDER_COMMENT') . '</th>',
	        '</tr></thead>',
	    );

	    foreach ($orders as $order) {
	        $html[] = '<tr>';

	        $html[] = '<td>';
	        $html[] = $order->getName() . ' ' . JText::_('JBZOO_BY');
	        if ($user = $order->getAuthor()) {
	            $href   = $zoo->component->users->link(array('task' => 'user.edit', 'layout' => 'edit', 'view' => 'user', 'id' => $user->id));
	            $html[] = '<i>' . $user->name . '</i>';
	        } else {
	            $html[] = '<i>' . JText::_('JBZOO_ANONYM') . '</i>';
	        }
	        $html[] = '</td>';

	        $html[] = '<td>' . $zoo->jbdate->toHuman($order->created) . '</td>';
	        $html[] = '<td>' . $order->getStatus()->getName() . '</td>';
	        $html[] = '<td>' . $order->getTotalSum(true) . '</td>';
	        $html[] = '<td>' . (($order->comment) ? $order->comment : ' - ') . '</td>';

	        $html[] = '</tr>';
	    }

	    $html[] = '</table>';
	    echo implode(PHP_EOL, $html);
	}
?>
</div>
