<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

$params = $this->config;
$userId = $this->getItem()->created_by;


?>
<div class="row <?php echo $this->identifier; ?> fl-galleryimage-submission" fl-galleryimage-images="<?php echo count($images); ?>">

    <div class="fl-galleryimage uk-grid">
        <div class="uk-width-1-1">
            <div class="upload">          
                <div id="fl-galleryimage-dropzone" class="galleryimage-dropzone well text-center">
                    <i class="icon-upload text-large"></i> Перетащите изображения сюда или <input class="<?php echo $this->identifier; ?>-galleryimage-fileupload" type="file" name="<?php echo $this->identifier; ?>-files[]" multiple>
                </div>
            </div>
            <div class="fl-alert alert alert-danger hidden"><span title="Спрятать предупреждение" class="alert-close close"></span></div>
            <ul class="fl-files thumbnails row-fluid">
                <?php
                    if ($images) {
                        foreach ($images as $key => $image) {
                            echo '<li class="fl-sort-images well span2 text-center" style="height:'.($params['thumb_height']*2).'">';
                            echo '<div class="fl-galleryimage-thumb text-success text-center">';
                            echo '<img src="/'.$this->getUploadImagePath().'/thumbnail/'.$image['name'].'">';
                            echo '<p style="font-size:smaller; margin-top:10px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><i class="fl-galleryimage-load-icon icon-ok"></i> '.$image['name'].'</p>';
                            echo '<a data-url="'.JURI::root().'media/zoo/applications/jbuniversal/elements/jbgalleryimage/upload/index.php?'.$this->identifier.'-file='.urlencode($image['name']).'" class="fl-button-delete btn btn-mini">Удалить</a>';
                            echo $this->app->html->_('control.text', $this->getGalleryImageControlName('name', $key), $image['name'], 'class="hidden"');
                            echo '</div>';
                        }
                    }
                ?>

            </ul> 
            <div class="progress hidden">
                <div class="bar"></div>
            </div>     
        </div>
    </div>
</div>

<script>
    (function($){
        $(".<?php echo $this->identifier; ?> .fl-files").sortable({
            cursor: "move",
            helper: "clone",
            tolerance: "pointer"
        });
        $(".<?php echo $this->identifier; ?> .fl-files").disableSelection();

        $('.<?php echo $this->identifier; ?>-galleryimage-fileupload').jbGalleryImageUploadEdit({
            'uploadId': '<?php echo $this->identifier; ?>',
            'url' : '<?php echo JURI::root(); ?>media/zoo/applications/jbuniversal/elements/jbgalleryimage/upload/index.php',
            'maxNumberOfFiles' : <?php echo $params['max_number']; ?>,
            'previewMaxWidth' : <?php echo $params['thumb_width']; ?>,
            'previewMaxHeight' : <?php echo $params['thumb_height']; ?>,
            'previewCrop': <?php echo ($params['thumb_crop']) ? 'true' : 'false'; ?>,
            'maxFileSize' : <?php echo $params['max_upload_size']*1000; ?>,
            'imageMaxWidth' : <?php echo $params['max_width']; ?>,
            'imageMaxHeight': <?php echo $params['max_height']; ?>,
            'userId' : '<?php echo $userId; ?>'
        }); 

        $(document).on('click', '.fl-galleryimage .fl-button-delete', function () {
            if (confirm('Вы уверены, что хотите удалить изображение?')) {
                $(this).jbGalleryImageUploadEdit('delete', {
                    'url' : $(this).data('url'),
                    'uploadId': '<?php echo $this->identifier; ?>',
                    'methodType': 'DELETE',
                    'userId' : '<?php echo $userId; ?>'
                })
                $(this).parents('.fl-sort-images').remove();
            };
        })

        $(document).on('click', '.alert .close', function () {
            $(this).parent().addClass('hidden').find('p').remove();
        })
    })(jQuery);
</script>